/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.filters.SubFilterAnnotation;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;

public class SubFilterEventConverter {
    private String parentId;
    private IdGenerator groupIdGenerator;
    private ISkeleton startGroupSkeleton;
    private ISkeleton endGroupSkeleton;

    public SubFilterEventConverter(String parentId, ISkeleton startGroupSkeleton, ISkeleton endGroupSkeleton) {
        this.groupIdGenerator = new IdGenerator(parentId);
        this.parentId = parentId;
        this.startGroupSkeleton = startGroupSkeleton;
        this.endGroupSkeleton = endGroupSkeleton;
    }

    public SubFilterEventConverter(String parentId, ISkeleton startGroupSkeleton, ISkeleton endGroupSkeleton, IdGenerator idGenerator) {
        idGenerator.reset(parentId);
        this.groupIdGenerator = idGenerator;
        this.parentId = parentId;
        this.startGroupSkeleton = startGroupSkeleton;
        this.endGroupSkeleton = endGroupSkeleton;
    }

    public Event convertEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                StartGroup startGroup = new StartGroup(this.parentId, this.groupIdGenerator.createId());
                startGroup.setMimeType(((StartDocument)event.getResource()).getMimeType());
                startGroup.setSkeleton(this.startGroupSkeleton);
                startGroup.setName("sub-filter:" + ((StartDocument)event.getResource()).getName());
                startGroup.setAnnotation(new SubFilterAnnotation());
                event = new Event(EventType.START_GROUP, startGroup);
                break;
            }
            case END_DOCUMENT: {
                Ending endGroup = new Ending(this.groupIdGenerator.getLastId("eg"));
                endGroup.setSkeleton(this.endGroupSkeleton);
                endGroup.setAnnotation(new SubFilterAnnotation());
                event = new Event(EventType.END_GROUP, endGroup);
                break;
            }
        }
        return event;
    }
}

