/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.threaded;

import net.sf.okapi.common.pipeline.IPipelineStep;

abstract class BaseThreadedPipelineStepAdaptor
implements Runnable {
    private IPipelineStep step;
    private volatile boolean cancelled;
    private volatile boolean destroyed;

    public BaseThreadedPipelineStepAdaptor(IPipelineStep step) {
        this.step = step;
        this.cancelled = false;
        this.destroyed = false;
    }

    public String getName() {
        return this.step.getName();
    }

    public void cancel() {
        this.step.cancel();
        this.cancelled = true;
    }

    public void destroy() {
        this.step.destroy();
        this.destroyed = true;
    }

    public IPipelineStep getStep() {
        return this.step;
    }

    protected abstract void processBlockingQueue();

    protected abstract void clearBlockingQueues();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.cancelled && !this.destroyed) {
            this.processBlockingQueue();
        }
        if (this.destroyed) {
            this.clearBlockingQueues();
            return;
        }
        if (this.cancelled) {
            BaseThreadedPipelineStepAdaptor baseThreadedPipelineStepAdaptor = this;
            synchronized (baseThreadedPipelineStepAdaptor) {
                while (this.cancelled) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        this.clearBlockingQueues();
                        return;
                    }
                }
            }
        }
    }
}

