/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryResultTest {
    private TextFragment source1;
    private TextFragment source2;
    private TextFragment source3;
    private TextFragment target1;
    private TextFragment target2;
    private TextFragment target3;
    private QueryResult at1;
    private QueryResult at2;
    private QueryResult at3;
    private QueryResult at4;
    private QueryResult at5;
    private QueryResult at6;
    private QueryResult at7;
    private QueryResult at8;
    private QueryResult at9;
    private QueryResult at10;
    private QueryResult at11;
    private QueryResult at12;

    @Before
    public void setUp() throws Exception {
        this.source1 = new TextFragment("source one");
        this.source2 = new TextFragment("source two");
        this.source3 = new TextFragment("source three");
        this.target1 = new TextFragment("target one");
        this.target2 = new TextFragment("target two");
        this.target3 = new TextFragment("target three");
        this.at1 = new QueryResult();
        this.at1.matchType = MatchType.MT;
        this.at1.score = 60;
        this.at1.source = this.source1;
        this.at1.target = this.target1;
        this.at2 = new QueryResult();
        this.at2.matchType = MatchType.EXACT;
        this.at2.score = 90;
        this.at2.source = this.source2;
        this.at2.target = this.target2;
        this.at3 = new QueryResult();
        this.at3.matchType = MatchType.EXACT_PREVIOUS_VERSION;
        this.at3.score = 100;
        this.at3.source = this.source3;
        this.at3.target = this.target3;
        this.at4 = new QueryResult();
        this.at4.matchType = MatchType.FUZZY;
        this.at4.score = 60;
        this.at4.source = this.source1;
        this.at4.target = this.target1;
        this.at5 = new QueryResult();
        this.at5.matchType = MatchType.EXACT_TEXT_ONLY;
        this.at5.score = 95;
        this.at5.source = this.source2;
        this.at5.target = this.target2;
        this.at6 = new QueryResult();
        this.at6.matchType = MatchType.FUZZY_UNIQUE_ID;
        this.at6.score = 99;
        this.at6.source = this.source3;
        this.at6.target = this.target3;
        this.at7 = new QueryResult();
        this.at7.matchType = MatchType.FUZZY;
        this.at7.score = 99;
        this.at7.source = this.source3;
        this.at7.target = this.target3;
        this.at8 = new QueryResult();
        this.at8.matchType = MatchType.FUZZY;
        this.at8.score = 98;
        this.at8.creationDate = new Date(2L);
        this.at8.source = this.source3;
        this.at8.target = this.target3;
        this.at9 = new QueryResult();
        this.at9.matchType = MatchType.FUZZY;
        this.at9.score = 98;
        this.at8.creationDate = new Date(1L);
        this.at9.source = this.source3;
        this.at9.target = this.target3;
        this.at10 = new QueryResult();
        this.at10.matchType = MatchType.FUZZY;
        this.at10.score = 99;
        this.at10.source = this.source3;
        this.at10.target = this.target3;
        this.at11 = new QueryResult();
        this.at11.matchType = MatchType.FUZZY;
        this.at11.score = 98;
        this.at11.source = this.source3;
        this.at11.target = this.target3;
        this.at12 = new QueryResult();
        this.at12.matchType = MatchType.FUZZY;
        this.at12.score = 97;
        this.at12.source = this.source3;
        this.at12.target = this.target3;
    }

    @Test
    public void QueryResultSortedList() {
        ArrayList<QueryResult> ats = new ArrayList<QueryResult>();
        ats.add(this.at1);
        ats.add(this.at2);
        ats.add(this.at3);
        Collections.sort(ats);
        junit.framework.Assert.assertSame((Object)this.at3, ats.get(0));
        junit.framework.Assert.assertSame((Object)this.at2, ats.get(1));
        junit.framework.Assert.assertSame((Object)this.at1, ats.get(2));
    }

    @Test
    public void QueryResultFuzzySortedList() {
        ArrayList<QueryResult> ats = new ArrayList<QueryResult>();
        ats.add(this.at4);
        ats.add(this.at5);
        ats.add(this.at6);
        Collections.sort(ats);
        junit.framework.Assert.assertSame((Object)this.at5, ats.get(0));
        junit.framework.Assert.assertSame((Object)this.at6, ats.get(1));
        junit.framework.Assert.assertSame((Object)this.at4, ats.get(2));
    }

    @Test
    public void QueryResultCreationDateSortedList() {
        ArrayList<QueryResult> ats = new ArrayList<QueryResult>();
        ats.add(this.at9);
        ats.add(this.at8);
        ats.add(this.at7);
        Collections.sort(ats);
        junit.framework.Assert.assertSame((Object)this.at7, ats.get(0));
        junit.framework.Assert.assertSame((Object)this.at8, ats.get(1));
        junit.framework.Assert.assertSame((Object)this.at9, ats.get(2));
    }

    @Test
    public void QueryResultScoreSortedList() {
        ArrayList<QueryResult> ats = new ArrayList<QueryResult>();
        ats.add(this.at10);
        ats.add(this.at11);
        ats.add(this.at12);
        Collections.sort(ats);
        junit.framework.Assert.assertSame((Object)this.at10, ats.get(0));
        junit.framework.Assert.assertSame((Object)this.at11, ats.get(1));
        junit.framework.Assert.assertSame((Object)this.at12, ats.get(2));
    }

    @Test
    public void instanceEquality() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        QueryResult h2 = h1;
        Assert.assertTrue((String)"instance equality", (boolean)h1.equals(h2));
    }

    @Test
    public void equals() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        Assert.assertTrue((String)"equals", (boolean)h1.equals(this.at2));
    }

    @Test
    public void notEquals() {
        Assert.assertFalse((String)"not equals", (boolean)this.at1.equals(this.at2));
    }

    @Test
    public void compareToEquals() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        Assert.assertEquals((long)0L, (long)h1.compareTo(this.at2));
    }

    @Test
    public void compareToGreaterThanScore() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.FUZZY;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.FUZZY;
        h2.score = 50;
        h2.source = this.source2;
        h2.target = this.target2;
        Assert.assertTrue((h1.compareTo(h2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToLessThanScore() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.FUZZY;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.FUZZY;
        h2.score = 50;
        h2.source = this.source2;
        h2.target = this.target2;
        Assert.assertTrue((h2.compareTo(h1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToLessThanMatchType() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.MT;
        h2.score = 90;
        h2.source = this.source2;
        h2.target = this.target2;
        Assert.assertTrue((h1.compareTo(h2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToGreaterThanMatchType() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = this.source2;
        h1.target = this.target2;
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.MT;
        h2.score = 90;
        h2.source = this.source2;
        h2.target = this.target2;
        Assert.assertTrue((h2.compareTo(h1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToLessThanSource() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = new TextFragment("A");
        h1.target = this.target2;
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.MT;
        h2.score = 90;
        h2.source = new TextFragment("B");
        h2.target = this.target2;
        Assert.assertTrue((h1.compareTo(h2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToGreaterThanSource() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 90;
        h1.source = new TextFragment("A");
        h1.target = this.target2;
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.MT;
        h2.score = 90;
        h2.source = new TextFragment("B");
        h2.target = this.target2;
        Assert.assertTrue((h2.compareTo(h1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void compareToWithCreationDates() {
        QueryResult h1 = new QueryResult();
        h1.matchType = MatchType.EXACT;
        h1.score = 100;
        h1.source = new TextFragment("A");
        h1.target = this.target2;
        h1.creationDate = new Date(0L);
        QueryResult h2 = new QueryResult();
        h2.matchType = MatchType.EXACT;
        h2.score = 100;
        h2.source = new TextFragment("A");
        h2.target = this.target2;
        h2.creationDate = new Date(1L);
        Assert.assertTrue((h2.compareTo(h1) < 0 ? 1 : 0) != 0);
    }
}

