/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;

@UsingParameters(value=Parameters.class)
public class MicrosoftMTConnector
extends BaseConnector
implements ITMQuery {
    private final String OPTIONS = "<TranslateOptions xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\"><Category>general</Category><ContentType>text/html</ContentType><ReservedFlags /><State /><Uri></Uri><User>defaultUser</User></TranslateOptions>";
    private final String PLACEHOLDER = "[$#@list@#$]";
    private QueryUtil util = new QueryUtil();
    Parameters params = new Parameters();
    int maximumHits = 1;
    int threshold = 95;
    private List<QueryResult> results;
    String queryListTemplate;
    String addListTemplate;

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Microsoft-Translator";
    }

    @Override
    public String getSettingsDisplay() {
        return "Service: http://api.microsofttranslator.com/V2/Http.svc";
    }

    @Override
    public void open() {
        this.results = new ArrayList<QueryResult>();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    private static String fromInputStreamToString(InputStream stream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int query(TextFragment frag) {
        this.current = -1;
        this.results.clear();
        if (!frag.hasText(false)) {
            return 0;
        }
        try {
            String stext = this.util.toCodedHTML(frag);
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/GetTranslations?appId=%s&text=%s&from=%s&to=%s&maxTranslations=%d", this.params.getAppId(), URLEncoder.encode(stext, "UTF-8"), this.srcCode, this.trgCode, this.maximumHits));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                osw.write("<TranslateOptions xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\"><Category>general</Category><ContentType>text/html</ContentType><ReservedFlags /><State /><Uri></Uri><User>defaultUser</User></TranslateOptions>");
            }
            finally {
                osw.flush();
                osw.close();
            }
            this.results = this.parseBlock(MicrosoftMTConnector.fromInputStreamToString(conn.getInputStream(), "UTF-8"), frag);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the MT server.\n" + e.getMessage(), e);
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    private String unescapeXML(String text) {
        text = text.replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        return text.replace("&amp;", "&");
    }

    private List<QueryResult> parseBlock(String block, TextFragment frag) {
        int n1;
        ArrayList<QueryResult> list = new ArrayList<QueryResult>(this.maximumHits);
        int from = 0;
        while ((n1 = block.indexOf("<TranslationMatch>", from)) >= 0) {
            int n2 = block.indexOf("</TranslationMatch>", n1);
            String res = block.substring(n1, n2);
            from = n2 + 1;
            n1 = res.indexOf("<MatchDegree>");
            n2 = res.indexOf("</MatchDegree>", n1 + 1);
            int score = Integer.parseInt(res.substring(n1 + 13, n2));
            int rating = 5;
            n1 = res.indexOf("<Rating", 0);
            n2 = res.indexOf("</Rating>", n1);
            if (n2 > -1) {
                rating = Integer.parseInt(res.substring(n1 + 8, n2));
            }
            if (score > 90) {
                score += rating - 10;
            }
            if (score < this.threshold) continue;
            n1 = res.indexOf("<MatchedOriginalText", 0);
            n2 = res.indexOf("</MatchedOriginalText", n1);
            String stext = null;
            if (n2 > -1) {
                stext = this.unescapeXML(res.substring(n1 + 21, n2));
            }
            String ttext = "";
            n1 = res.indexOf("<TranslatedText", n2);
            if ((n2 = res.indexOf("</TranslatedText", n1)) > -1) {
                ttext = this.unescapeXML(res.substring(n1 + 16, n2));
            }
            QueryResult qr = new QueryResult();
            qr.score = score;
            qr.weight = this.getWeight();
            if (frag.hasCode()) {
                qr.source = stext == null ? frag : new TextFragment(this.util.fromCodedHTML(stext, frag, false), frag.getClonedCodes());
                qr.target = new TextFragment(this.util.fromCodedHTML(ttext, frag, false), frag.getClonedCodes());
            } else {
                qr.source = stext == null ? frag : new TextFragment(this.util.fromCodedHTML(stext, frag, false));
                qr.target = new TextFragment(this.util.fromCodedHTML(ttext, frag, false));
            }
            qr.origin = this.getName();
            qr.matchType = MatchType.MT;
            list.add(qr);
        }
        return list;
    }

    private List<List<QueryResult>> parseAllBlocks(String resp, List<TextFragment> fragments) {
        ArrayList<List<QueryResult>> list = new ArrayList<List<QueryResult>>();
        int from = 0;
        for (TextFragment frag : fragments) {
            if ((from = resp.indexOf("<Translations>", from)) < 0) break;
            int n = resp.indexOf("</Translations>", from);
            String block = resp.substring(from, n);
            from = n + 1;
            list.add(this.parseBlock(block, frag));
        }
        return list;
    }

    public int addTranslation(TextFragment source, TextFragment target, int rating) {
        try {
            String stext = this.util.toCodedHTML(source);
            String ttext = this.util.toCodedHTML(target);
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/AddTranslation?appId=%s&originaltext=%s&translatedtext=%s&from=%s&to=%s&user=defaultUser&rating=%d", this.params.getAppId(), URLEncoder.encode(stext, "UTF-8"), URLEncoder.encode(ttext, "UTF-8"), this.srcCode, this.trgCode, rating));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            return conn.getResponseCode();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error adding translation to the server.\n" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTranslationList(List<TextFragment> sources, List<TextFragment> targets, List<Integer> ratings) {
        StringWriter strWriter = null;
        try {
            if (targets.size() != sources.size()) {
                throw new RuntimeException("There should be as many targets as sources.");
            }
            if (ratings.size() != sources.size()) {
                throw new RuntimeException("There should be as many ratings as sources.");
            }
            if (sources.size() > 100) {
                throw new RuntimeException("No more than 100 segments allowed.");
            }
            if (this.addListTemplate == null) {
                strWriter = new StringWriter();
                XMLWriter xmlWriter = new XMLWriter(strWriter);
                xmlWriter.writeStartDocument();
                xmlWriter.writeStartElement("AddtranslationsRequest");
                xmlWriter.writeAttributeString("xmlns:o", "http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2");
                xmlWriter.writeElementString("AppId", this.params.getAppId());
                xmlWriter.writeElementString("From", this.srcCode);
                xmlWriter.writeStartElement("Options");
                xmlWriter.writeElementString("o:Category", "");
                xmlWriter.writeElementString("o:ContentType", "text/html");
                xmlWriter.writeElementString("o:ReservedFlags", "");
                xmlWriter.writeElementString("o:State", "");
                xmlWriter.writeElementString("o:Uri", "");
                xmlWriter.writeElementString("o:User", "defaultUser");
                xmlWriter.writeEndElement();
                xmlWriter.writeElementString("To", this.trgCode);
                xmlWriter.writeStartElement("Translations");
                xmlWriter.writeRawXML("[$#@list@#$]");
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
                xmlWriter.writeEndDocument();
                xmlWriter.close();
                strWriter.close();
                this.addListTemplate = strWriter.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sources.size(); ++i) {
                TextFragment src = sources.get(i);
                TextFragment trg = targets.get(i);
                int rating = ratings.get(i);
                if (rating < -10 && rating > 10) {
                    rating = 4;
                }
                sb.append("<o:Translation>");
                sb.append("<o:OriginalText>");
                String tmp = this.util.toCodedHTML(src);
                sb.append(Util.escapeToXML(tmp, 0, false, null));
                sb.append("</o:OriginalText>");
                sb.append(String.format("<o:Rating>%d</o:Rating>", rating));
                sb.append(String.format("<o:Sequence>%d</o:Sequence>", 0));
                sb.append("<o:TranslatedText>");
                tmp = this.util.toCodedHTML(trg);
                sb.append(Util.escapeToXML(tmp, 0, false, null));
                sb.append("</o:TranslatedText>");
                sb.append("</o:Translation>");
            }
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/AddTranslationArray", new Object[0]));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                String query = this.addListTemplate.replace("[$#@list@#$]", sb.toString());
                osw.write(query);
            }
            finally {
                osw.flush();
                osw.close();
            }
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("HTTP error when adding translation.\n" + conn.getResponseMessage());
            }
            return code;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error adding translations.\n" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<QueryResult>> queryList(List<TextFragment> fragments) {
        List<List<QueryResult>> list = new ArrayList<List<QueryResult>>();
        StringWriter strWriter = null;
        try {
            if (this.queryListTemplate == null) {
                strWriter = new StringWriter();
                XMLWriter xmlWriter = new XMLWriter(strWriter);
                xmlWriter.writeStartDocument();
                xmlWriter.writeStartElement("GetTranslationsArrayRequest");
                xmlWriter.writeElementString("AppId", this.params.getAppId());
                xmlWriter.writeElementString("From", this.srcCode);
                xmlWriter.writeStartElement("Options");
                xmlWriter.writeAttributeString("xmlns:o", "http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2");
                xmlWriter.writeElementString("o:Category", "");
                xmlWriter.writeElementString("o:ContentType", "text/html");
                xmlWriter.writeElementString("o:ReservedFlags", "");
                xmlWriter.writeElementString("o:State", "");
                xmlWriter.writeElementString("o:Uri", "");
                xmlWriter.writeElementString("o:User", "");
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("Texts");
                xmlWriter.writeAttributeString("xmlns:s", "http://schemas.microsoft.com/2003/10/Serialization/Arrays");
                xmlWriter.writeRawXML("[$#@list@#$]");
                xmlWriter.writeEndElement();
                xmlWriter.writeElementString("To", this.trgCode);
                xmlWriter.writeElementString("MaxTranslations", String.valueOf(this.maximumHits));
                xmlWriter.writeEndElement();
                xmlWriter.writeEndDocument();
                xmlWriter.close();
                strWriter.close();
                this.queryListTemplate = strWriter.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (TextFragment tf : fragments) {
                sb.append("<s:string>");
                String stext = this.util.toCodedHTML(tf);
                sb.append(Util.escapeToXML(stext, 0, false, null));
                sb.append("</s:string>");
            }
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/GetTranslationsArray?appId=%s", this.params.getAppId()));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                String query = this.queryListTemplate.replace("[$#@list@#$]", sb.toString());
                osw.write(query);
            }
            finally {
                osw.flush();
                osw.close();
            }
            int code = conn.getResponseCode();
            if (code == 200) {
                list = this.parseAllBlocks(MicrosoftMTConnector.fromInputStreamToString(conn.getInputStream(), "UTF-8"), fragments);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("URL error in connector.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error with connector.", e);
        }
        return list;
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        code = code.equals("zh-tw") || code.equals("zh-hant") || code.equals("zh-cht") ? "zh-CHT" : (code.startsWith("zh") ? "zh-CHS" : locale.getLanguage());
        return code;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public int getMaximumHits() {
        return this.maximumHits;
    }

    @Override
    public void setMaximumHits(int maximumHits) {
        this.maximumHits = maximumHits;
        this.queryListTemplate = null;
        this.addListTemplate = null;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        this.queryListTemplate = null;
        this.addListTemplate = null;
    }
}

