/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.mymemory;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.mymemory.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import org.apache.axis.AxisFault;
import org.tempuri.GetResponse;
import org.tempuri.Match;
import org.tempuri.OtmsSoapStub;
import org.tempuri.Query;

public class MyMemoryTMConnector
extends BaseConnector
implements ITMQuery {
    private static final String SERVER_URL = "http://mymemory.translated.net/otms/";
    private List<QueryResult> results;
    private int current = -1;
    private int maxHits = 25;
    private int threshold = 75;
    private Parameters params = new Parameters();
    private OtmsSoapStub otms;
    private QueryUtil qutil = new QueryUtil();

    @Override
    public String getName() {
        return "MyMemory.net";
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("Server: %s\nAllow MT: %s", SERVER_URL, this.params.getUseMT() == 1 ? "Yes" : "No");
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
        try {
            this.results = new ArrayList<QueryResult>();
            URL url = new URL(SERVER_URL);
            this.otms = new OtmsSoapStub(url, null);
        }
        catch (AxisFault e) {
            throw new RuntimeException("Error creating the MyMemory Web services.", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid server URL.", e);
        }
    }

    @Override
    public int query(TextFragment frag) {
        block15: {
            this.results.clear();
            this.current = -1;
            if (!frag.hasText(false)) {
                return 0;
            }
            try {
                String text = this.qutil.separateCodesFromText(frag);
                Query query = new Query(null, text, this.srcCode, this.trgCode, null, this.params.getUseMT());
                GetResponse gresp = this.otms.otmsGet(this.params.getKey(), query);
                if (!gresp.isSuccess()) break block15;
                Match[] matches = gresp.getMatches();
                int i = 0;
                for (Match match : matches) {
                    if (++i <= this.maxHits) {
                        QueryResult res = new QueryResult();
                        res.weight = this.getWeight();
                        res.origin = this.getName();
                        if (match.getTranslator().equals("MT!")) {
                            res.matchType = MatchType.MT;
                            res.score = 95;
                        } else {
                            res.score = match.getScore();
                        }
                        if (res.score > 100) {
                            res.score = 100;
                        }
                        if (res.score >= 100) {
                            res.matchType = MatchType.EXACT;
                        } else if (res.score > 0) {
                            res.matchType = MatchType.FUZZY;
                        }
                        if (res.score >= this.getThreshold()) {
                            if (this.qutil.hasCode()) {
                                --res.score;
                                res.source = this.qutil.createNewFragmentWithCodes(match.getSegment());
                                res.target = this.qutil.createNewFragmentWithCodes(match.getTranslation());
                            } else {
                                res.source = new TextFragment(match.getSegment());
                                res.target = new TextFragment(match.getTranslation());
                            }
                            this.results.add(res);
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException("Error querying TM.", e);
            }
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String lang = locale.getLanguage();
        String reg = locale.getRegion();
        if (lang.equals("en")) {
            reg = "us";
        } else if (lang.equals("pt")) {
            reg = "br";
        } else if (lang.equals("el")) {
            reg = "gr";
        } else if (lang.equals("he")) {
            reg = "il";
        } else if (lang.equals("ja")) {
            reg = "jp";
        } else if (lang.equals("ko")) {
            reg = "kr";
        } else if (lang.equals("ms")) {
            reg = "my";
        } else if (lang.equals("sl")) {
            reg = "si";
        } else if (lang.equals("sq")) {
            reg = "al";
        } else if (lang.equals("sv")) {
            reg = "se";
        } else if (lang.equals("vi")) {
            reg = "vn";
        } else if (lang.equals("zh")) {
            if (reg != null) {
                reg = "cn";
            }
        } else {
            reg = lang;
        }
        return lang + "-" + reg;
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max < 1 ? 1 : max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }
}

