/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.filters.idml.NodeReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IDMLSkeleton
implements ISkeleton {
    public static final String NODEREMARKER = "SKLREF";
    private ZipFile original;
    private ZipEntry entry;
    private Document doc;
    private Node topNode;
    private Node scopeNode;
    private HashMap<String, NodeReference> refs;
    private String[] movedParts;

    public IDMLSkeleton(ZipFile original) {
        this.original = original;
    }

    public IDMLSkeleton(ZipEntry entry, Document doc) {
        this.entry = entry;
        this.doc = doc;
    }

    public IDMLSkeleton(Node topNode, Node scopeNode) {
        this.topNode = topNode;
        this.scopeNode = scopeNode;
    }

    public void addReferenceNode(String id, NodeReference ref) {
        if (this.refs == null) {
            this.refs = new HashMap();
        }
        this.refs.put(id, ref);
    }

    public void addMovedParts(String[] movedParts) {
        this.movedParts = movedParts;
    }

    public String[] getMovedParts() {
        return this.movedParts;
    }

    public boolean hasReferences() {
        return this.refs != null && this.refs.size() > 0;
    }

    public HashMap<String, NodeReference> getReferences() {
        return this.refs;
    }

    public ZipFile getOriginal() {
        return this.original;
    }

    public ZipEntry getEntry() {
        return this.entry;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public Node getScopeNode() {
        return this.scopeNode;
    }
}

