/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rainbowkit;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Base64;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Manifest
implements IAnnotation {
    public static final String EXTRACTIONTYPE_NONE = "none";
    public static final String EXTRACTIONTYPE_XLIFF = "xliff";
    public static final String EXTRACTIONTYPE_XLIFF2 = "xliff2";
    public static final String EXTRACTIONTYPE_PO = "po";
    public static final String EXTRACTIONTYPE_RTF = "rtf";
    public static final String EXTRACTIONTYPE_VERSIFIED_RTF = "versified+rtf";
    public static final String EXTRACTIONTYPE_VERSIFIED = "versified";
    public static final String EXTRACTIONTYPE_XLIFFRTF = "xliff+rtf";
    public static final String EXTRACTIONTYPE_OMEGAT = "omegat";
    public static final String EXTRACTIONTYPE_TRANSIFEX = "transifex";
    public static final String EXTRACTIONTYPE_ONTRAM = "ontram";
    public static final String VERSION = "2";
    public static final String MANIFEST_FILENAME = "manifest";
    public static final String MANIFEST_EXTENSION = ".rkm";
    private LinkedHashMap<Integer, MergingInfo> docs = new LinkedHashMap();
    private String packageRoot = "";
    private String packageId;
    private String projectId;
    private LocaleId sourceLoc;
    private LocaleId targetLoc;
    private String inputRoot;
    private String originalSubDir = "";
    private String sourceSubDir = "";
    private String targetSubDir = "";
    private String tmSubDir = "";
    private String mergeSubDir = "";
    private String originalDir;
    private String sourceDir;
    private String targetDir;
    private String mergeDir;
    private String tmDir;
    private String creatorParams;
    private boolean useApprovedOnly;
    private boolean updateApprovedFlag;
    private String date;

    public Manifest() {
        this.updateFullDirectories();
        this.useApprovedOnly = false;
        this.updateApprovedFlag = false;
    }

    public Map<Integer, MergingInfo> getItems() {
        return this.docs;
    }

    public MergingInfo getItem(int docID) {
        return this.docs.get(docID);
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLoc;
    }

    public LocaleId getTargetLocale() {
        return this.targetLoc;
    }

    public String getCreatorParameters() {
        return this.creatorParams;
    }

    public boolean getUseApprovedOnly() {
        return this.useApprovedOnly;
    }

    public void setUseApprovedOnly(boolean value) {
        this.useApprovedOnly = value;
    }

    public boolean getUpdateApprovedFlag() {
        return this.updateApprovedFlag;
    }

    public void setUpdateApprovedFlag(boolean value) {
        this.updateApprovedFlag = value;
    }

    public String getInputRoot() {
        return this.inputRoot;
    }

    public String getPackageRoot() {
        return this.packageRoot;
    }

    public void setSubDirectories(String originalSubDir, String sourceSubDir, String targetSubDir, String mergeSubDir, String tmSubDir, boolean overwrite) {
        if (originalSubDir != null && (overwrite || Util.isEmpty(this.originalSubDir))) {
            this.originalSubDir = originalSubDir;
        }
        if (sourceSubDir != null && (overwrite || Util.isEmpty(this.sourceSubDir))) {
            this.sourceSubDir = sourceSubDir;
        }
        if (targetSubDir != null && (overwrite || Util.isEmpty(this.targetSubDir))) {
            this.targetSubDir = targetSubDir;
        }
        if (mergeSubDir != null && (overwrite || Util.isEmpty(this.mergeSubDir))) {
            this.mergeSubDir = mergeSubDir;
        }
        if (tmSubDir != null && (overwrite || Util.isEmpty(this.tmSubDir))) {
            this.tmSubDir = tmSubDir;
        }
        this.updateFullDirectories();
    }

    public String getOriginalDirectory() {
        return this.originalDir;
    }

    public String getSourceDirectory() {
        return this.sourceDir;
    }

    public String getTargetDirectory() {
        return this.targetDir;
    }

    public String getMergeDirectory() {
        return this.mergeDir;
    }

    public String getTmDirectory() {
        return this.tmDir;
    }

    public String getDate() {
        return this.date;
    }

    public void setInformation(String packageRoot, LocaleId srcLoc, LocaleId trgLoc, String inputRoot, String packageId, String projectId, String creatorParams) {
        this.sourceLoc = srcLoc;
        this.targetLoc = trgLoc;
        this.inputRoot = Util.ensureSeparator(inputRoot, false);
        this.packageRoot = Util.ensureSeparator(packageRoot, false);
        this.packageId = packageId;
        this.projectId = projectId;
        this.updateFullDirectories();
        this.creatorParams = creatorParams;
    }

    public void addDocument(int docId, String extractionType, String relativeInputPath, String filterId, String filterParameters, String inputEncoding, String relativeTargetPath, String targetEncoding) {
        this.docs.put(docId, new MergingInfo(docId, extractionType, relativeInputPath, filterId, filterParameters, inputEncoding, relativeTargetPath, targetEncoding));
    }

    public String getPath() {
        return this.packageRoot + MANIFEST_FILENAME + MANIFEST_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Save() {
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(this.getPath());
            writer.writeStartDocument();
            writer.writeComment("=================================================================", true);
            writer.writeComment("PLEASE, DO NOT RENAME, MOVE, MODIFY OR ALTER IN ANY WAY THIS FILE", true);
            writer.writeComment("=================================================================", true);
            writer.writeStartElement(MANIFEST_FILENAME);
            writer.writeAttributeString("version", VERSION);
            writer.writeAttributeString("projectId", this.projectId);
            writer.writeAttributeString("packageId", this.packageId);
            writer.writeAttributeString("source", this.sourceLoc.toString());
            writer.writeAttributeString("target", this.targetLoc.toString());
            writer.writeAttributeString("originalSubDir", this.originalSubDir.replace('\\', '/'));
            writer.writeAttributeString("sourceSubDir", this.sourceSubDir.replace('\\', '/'));
            writer.writeAttributeString("targetSubDir", this.targetSubDir.replace('\\', '/'));
            writer.writeAttributeString("mergeSubDir", this.mergeSubDir.replace('\\', '/'));
            writer.writeAttributeString("tmSubDir", this.tmSubDir.replace('\\', '/'));
            SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            this.date = DF.format(new Date());
            writer.writeAttributeString("date", this.date);
            writer.writeAttributeString("useApprovedOnly", this.useApprovedOnly ? "1" : "0");
            writer.writeAttributeString("updateApprovedFlag", this.updateApprovedFlag ? "1" : "0");
            writer.writeLineBreak();
            writer.writeStartElement("creatorParameters");
            writer.writeString(Base64.encodeString(this.creatorParams.toString()));
            writer.writeEndElementLineBreak();
            for (MergingInfo item : this.docs.values()) {
                writer.writeRawXML(item.writeToXML("doc", true));
                writer.writeLineBreak();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void load(File inputFile) {
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            Document doc = docFac.newDocumentBuilder().parse(inputFile);
            NodeList NL = doc.getElementsByTagName(MANIFEST_FILENAME);
            if (NL == null) {
                throw new RuntimeException("Invalid manifest file.");
            }
            Element elem = (Element)NL.item(0);
            if (elem == null) {
                throw new RuntimeException("Invalid manifest file.");
            }
            String tmp = elem.getAttribute("version");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing vaersion attribute.");
            }
            tmp = elem.getAttribute("projectId");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing projectId attribute.");
            }
            this.projectId = tmp;
            tmp = elem.getAttribute("packageId");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing packageId attribute.");
            }
            this.packageId = tmp;
            tmp = elem.getAttribute("source");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing source attribute.");
            }
            this.sourceLoc = LocaleId.fromString(tmp);
            tmp = elem.getAttribute("target");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing target attribute.");
            }
            this.targetLoc = LocaleId.fromString(tmp);
            this.date = elem.getAttribute("date");
            if (Util.isEmpty(tmp)) {
                this.date = "Unknown";
            }
            if (Util.isEmpty(tmp = elem.getAttribute("originalSubDir"))) {
                throw new RuntimeException("Missing originalSubDir attribute.");
            }
            this.originalSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("sourceSubDir");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing sourceSubDir attribute.");
            }
            this.sourceSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("targetSubDir");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing targetSubDir attribute.");
            }
            this.targetSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("mergeSubDir");
            if (Util.isEmpty(tmp)) {
                throw new RuntimeException("Missing mergeSubDir attribute.");
            }
            this.mergeSubDir = tmp.replace('/', File.separatorChar);
            tmp = elem.getAttribute("tmSubDir");
            this.tmSubDir = Util.isEmpty(tmp) ? "" : tmp.replace('/', File.separatorChar);
            NL = elem.getElementsByTagName("creatorParameters");
            this.creatorParams = NL.getLength() > 0 ? Base64.decodeString(Util.getTextContent(NL.item(0))) : "";
            tmp = elem.getAttribute("useApprovedOnly");
            this.useApprovedOnly = Util.isEmpty(tmp) ? false : !tmp.equals("0");
            tmp = elem.getAttribute("updateApprovedFlag");
            this.updateApprovedFlag = Util.isEmpty(tmp) ? true : !tmp.equals("0");
            this.docs.clear();
            NL = elem.getElementsByTagName("doc");
            for (int i = 0; i < NL.getLength(); ++i) {
                elem = (Element)NL.item(i);
                MergingInfo item = MergingInfo.readFromXML(elem);
                this.docs.put(item.getDocId(), item);
            }
            this.packageRoot = Util.ensureSeparator(Util.getDirectoryName(inputFile.getAbsolutePath()), false);
            this.updateFullDirectories();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateFullDirectories() {
        this.originalDir = Util.ensureSeparator(this.packageRoot + this.originalSubDir, false);
        this.sourceDir = Util.ensureSeparator(this.packageRoot + this.sourceSubDir, false);
        this.targetDir = Util.ensureSeparator(this.packageRoot + this.targetSubDir, false);
        this.mergeDir = Util.ensureSeparator(this.packageRoot + this.mergeSubDir, false);
        this.tmDir = Util.ensureSeparator(this.packageRoot + this.tmSubDir, false);
    }
}

