/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.versifiedtxt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class VersifiedTextWriter
implements IFilterWriter {
    private OutputStream output;
    private String outputPath;
    private OutputStreamWriter writer;
    private LocaleId language;
    private String encoding;
    private String linebreak;
    private File tempFile;
    private GenericContent formatter = new GenericContent();
    private int verseCount = 0;

    @Override
    public String getName() {
        return "VersifiedTextWriter";
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.outputPath = null;
        this.output = output;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            default: {
                event = Event.NOOP_EVENT;
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output.close();
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new RuntimeException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    private void createWriter(StartDocument startDoc) {
        this.linebreak = startDoc.getLineBreak();
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("vrszwTmp", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = startDoc.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = false;
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void processStartDocument(Event event) {
        try {
            this.verseCount = 0;
            StartDocument sd = event.getStartDocument();
            this.createWriter(sd);
            this.writer.write("|b" + sd.getName() + this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing the versified text file header.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processStartSubDocument(Event event) {
        try {
            this.verseCount = 0;
            StartSubDocument ssd = (StartSubDocument)event.getResource();
            this.writer.write("|c" + ssd.getName() + this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing subdocument (|cName).", e);
        }
    }

    private void processTextUnit(Event event) {
        try {
            ITextUnit tu = event.getTextUnit();
            if (tu.isEmpty()) {
                return;
            }
            this.writer.write("|v" + String.valueOf(++this.verseCount) + this.linebreak);
            this.writeTextContainer(tu.getSource());
            if (tu.getTarget(this.language) != null) {
                this.writer.write("<TARGET>" + this.linebreak);
                this.writeTextContainer(tu.getTarget(this.language));
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a versified text unit.", e);
        }
    }

    private void writeTextContainer(TextContainer tc) {
        try {
            if (tc == null) {
                this.writer.write(this.linebreak);
                return;
            }
            String tmp = this.formatter.printSegmentedContent(tc, false, true);
            this.writer.write(tmp);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing TextContainer.", e);
        }
    }
}

