/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.steps;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;

public class EventLogger
extends BasePipelineStep {
    private int indent = 0;
    private boolean increasing = true;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private StringBuilder sb;

    @Override
    public String getDescription() {
        return "Logs events going through the pipeline.";
    }

    @Override
    public String getName() {
        return "Event logger";
    }

    private String getEventDescr(Event event) {
        String res = "";
        if (event.getResource() != null) {
            res = String.format("  [%s]", event.getResource().getId());
        }
        switch (event.getEventType()) {
            case TEXT_UNIT: {
                res = "  " + event.getResource().getId();
                break;
            }
            case START_DOCUMENT: {
                res = res + "  " + ((StartDocument)event.getResource()).getName();
                break;
            }
            case START_SUBDOCUMENT: {
                res = res + "  " + ((StartSubDocument)event.getResource()).getName();
            }
        }
        return res;
    }

    private void printEvent(Event event) {
        String indentStr = "";
        for (int i = 0; i < this.indent; ++i) {
            indentStr = indentStr + "  ";
        }
        this.sb.append(indentStr);
        this.sb.append((Object)((Object)event.getEventType()) + this.getEventDescr(event));
        this.sb.append("\n");
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.sb = new StringBuilder("\n\n");
            }
            case START_DOCUMENT: 
            case START_SUBDOCUMENT: 
            case START_GROUP: 
            case START_BATCH_ITEM: {
                if (!this.increasing) {
                    this.sb.append("\n");
                }
                this.printEvent(event);
                ++this.indent;
                this.increasing = true;
                break;
            }
            case END_DOCUMENT: 
            case END_SUBDOCUMENT: 
            case END_GROUP: 
            case END_BATCH: 
            case END_BATCH_ITEM: {
                if (this.indent > 0) {
                    --this.indent;
                }
                this.increasing = false;
                this.printEvent(event);
                if (event.getEventType() != EventType.END_BATCH) break;
                this.logger.setLevel(Level.FINE);
                this.logger.fine(this.sb.toString());
                break;
            }
            default: {
                if (!this.increasing) {
                    this.sb.append("\n");
                }
                this.printEvent(event);
            }
        }
        return super.handleEvent(event);
    }
}

