/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.segmentation.CompiledRule;
import net.sf.okapi.lib.segmentation.SegmentationRuleException;

public class SRXSegmenter
implements ISegmenter {
    private boolean segmentSubFlows;
    private boolean cascade;
    private boolean includeStartCodes;
    private boolean includeEndCodes;
    private boolean includeIsolatedCodes;
    private LocaleId currentLanguageCode;
    private boolean oneSegmentIncludesAll;
    private boolean trimLeadingWS;
    private boolean trimTrailingWS;
    private boolean trimCodes;
    private ArrayList<CompiledRule> rules;
    private Pattern maskRule;
    private TreeMap<Integer, Boolean> splits;
    private List<Integer> finalSplits;
    private ArrayList<Integer> starts;
    private ArrayList<Integer> ends;

    public SRXSegmenter() {
        this.reset();
    }

    public void reset() {
        this.currentLanguageCode = null;
        this.rules = new ArrayList();
        this.maskRule = null;
        this.splits = null;
        this.segmentSubFlows = true;
        this.cascade = false;
        this.includeStartCodes = false;
        this.includeEndCodes = true;
        this.includeIsolatedCodes = false;
        this.oneSegmentIncludesAll = false;
        this.trimLeadingWS = false;
        this.trimTrailingWS = false;
        this.trimCodes = false;
    }

    public void setOptions(boolean segmentSubFlows, boolean includeStartCodes, boolean includeEndCodes, boolean includeIsolatedCodes, boolean oneSegmentIncludesAll, boolean trimLeadingWS, boolean trimTrailingWS) {
        this.segmentSubFlows = segmentSubFlows;
        this.includeStartCodes = includeStartCodes;
        this.includeEndCodes = includeEndCodes;
        this.includeIsolatedCodes = includeIsolatedCodes;
        this.oneSegmentIncludesAll = oneSegmentIncludesAll;
        this.trimLeadingWS = trimLeadingWS;
        this.trimTrailingWS = trimTrailingWS;
    }

    public boolean oneSegmentIncludesAll() {
        return this.oneSegmentIncludesAll;
    }

    public boolean segmentSubFlows() {
        return this.segmentSubFlows;
    }

    public boolean cascade() {
        return this.cascade;
    }

    public boolean trimLeadingWhitespaces() {
        return this.trimLeadingWS;
    }

    public boolean trimTrailingWhitespaces() {
        return this.trimTrailingWS;
    }

    public boolean includeStartCodes() {
        return this.includeStartCodes;
    }

    public boolean includeEndCodes() {
        return this.includeEndCodes;
    }

    public boolean includeIsolatedCodes() {
        return this.includeIsolatedCodes;
    }

    @Override
    public int computeSegments(String text) {
        TextContainer tmp = new TextContainer(text);
        return this.computeSegments(tmp);
    }

    @Override
    public int computeSegments(TextContainer container) {
        Matcher m;
        boolean isECWS;
        boolean isSCWS;
        if (this.currentLanguageCode == null) {
            throw new SegmentationRuleException("No language defined for the segmenter.");
        }
        boolean hasCode = container.contentIsOneSegment() ? container.getSegments().getFirstContent().hasCode() : container.getUnSegmentedContentCopy().hasCode();
        boolean bl = this.trimCodes ? !this.includeStartCodes : (isSCWS = false);
        boolean bl2 = this.trimCodes ? !this.includeEndCodes : (isECWS = false);
        boolean isICWS = this.trimCodes ? !this.includeIsolatedCodes : false;
        String codedText = container.getCodedText();
        this.splits = new TreeMap();
        for (CompiledRule rule : this.rules) {
            m = rule.pattern.matcher(codedText);
            while (m.find()) {
                int n = m.start() + m.group(1).length();
                if (n >= codedText.length() || this.splits.containsKey(n)) continue;
                this.splits.put(n, rule.isBreak);
            }
        }
        if (this.maskRule != null) {
            m = this.maskRule.matcher(codedText);
            while (m.find()) {
                for (int n = m.start(); n < m.end(); ++n) {
                    if (!this.splits.containsKey(n)) continue;
                    this.splits.remove(n);
                }
                if (m.start() > 0) {
                    this.splits.put(m.start(), true);
                }
                this.splits.put(m.end(), true);
            }
        }
        this.finalSplits = new ArrayList<Integer>();
        if (hasCode) {
            for (int pos : this.splits.keySet()) {
                if (!this.splits.get(pos).booleanValue()) continue;
                int finalPos = pos;
                boolean done = false;
                block13: while (finalPos > 1 && !done) {
                    switch (codedText.charAt(finalPos - 2)) {
                        case '\ue101': 
                        case '\ue102': 
                        case '\ue103': {
                            finalPos -= 2;
                            continue block13;
                        }
                    }
                    done = true;
                }
                done = false;
                block14: while (finalPos < pos && !done) {
                    switch (codedText.charAt(finalPos)) {
                        case '\ue101': {
                            if (this.includeStartCodes) {
                                finalPos += 2;
                                continue block14;
                            }
                            done = true;
                            continue block14;
                        }
                        case '\ue102': {
                            if (this.includeEndCodes) {
                                finalPos += 2;
                                continue block14;
                            }
                            done = true;
                            continue block14;
                        }
                        case '\ue103': {
                            if (this.includeIsolatedCodes) {
                                finalPos += 2;
                                continue block14;
                            }
                            done = true;
                            continue block14;
                        }
                    }
                    done = true;
                }
                this.finalSplits.add(finalPos);
            }
        } else {
            Iterator<Object> i$ = this.splits.keySet().iterator();
            while (i$.hasNext()) {
                int pos = (Integer)i$.next();
                if (!this.splits.get(pos).booleanValue()) continue;
                this.finalSplits.add(pos);
            }
        }
        this.starts = new ArrayList();
        this.ends = new ArrayList();
        int textStart = 0;
        for (int pos : this.finalSplits) {
            int textEnd;
            int trimmedTextStart = TextFragment.indexOfFirstNonWhitespace(codedText, textStart, pos - 1, isSCWS, isECWS, isICWS, this.trimLeadingWS);
            if (trimmedTextStart == -1) continue;
            if (this.trimLeadingWS || this.trimCodes) {
                textStart = trimmedTextStart;
            }
            if ((textEnd = this.trimTrailingWS || this.trimCodes ? TextFragment.indexOfLastNonWhitespace(codedText, pos - 1, 0, isSCWS, isECWS, isICWS, this.trimTrailingWS) : pos - 1) >= textStart) {
                if (textEnd < pos) {
                    ++textEnd;
                }
                this.starts.add(textStart);
                this.ends.add(textEnd);
            }
            textStart = pos;
        }
        int lastPos = codedText.length();
        if (textStart < lastPos) {
            int textEnd;
            int trimmedTextStart = TextFragment.indexOfFirstNonWhitespace(codedText, textStart, lastPos - 1, isSCWS, isECWS, isICWS, this.trimLeadingWS);
            if ((this.trimLeadingWS || this.trimCodes) && trimmedTextStart != -1) {
                textStart = trimmedTextStart;
            }
            if (trimmedTextStart != -1 && trimmedTextStart < lastPos && (textEnd = this.trimTrailingWS || this.trimCodes ? TextFragment.indexOfLastNonWhitespace(codedText, lastPos - 1, textStart, isSCWS, isECWS, isICWS, this.trimTrailingWS) : lastPos - 1) >= textStart) {
                if (textEnd < lastPos) {
                    ++textEnd;
                }
                this.starts.add(textStart);
                this.ends.add(textEnd);
            }
        }
        if (this.starts.size() == 1 && this.oneSegmentIncludesAll) {
            this.starts.set(0, 0);
            this.ends.clear();
        }
        this.ends.add(lastPos);
        return this.starts.size();
    }

    @Override
    public Range getNextSegmentRange(TextContainer container) {
        return null;
    }

    @Override
    public List<Integer> getSplitPositions() {
        if (this.finalSplits == null) {
            this.finalSplits = new ArrayList<Integer>();
        }
        return this.finalSplits;
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> list = new ArrayList<Range>();
        if (this.starts == null) {
            return null;
        }
        for (int i = 0; i < this.starts.size(); ++i) {
            list.add(new Range(this.starts.get(i), this.ends.get(i)));
        }
        return list;
    }

    @Override
    public LocaleId getLanguage() {
        return this.currentLanguageCode;
    }

    protected void setLanguage(LocaleId languageCode) {
        this.currentLanguageCode = languageCode;
    }

    protected void setCascade(boolean value) {
        this.cascade = value;
    }

    protected void addRule(CompiledRule compiledRule) {
        this.rules.add(compiledRule);
    }

    protected void setMaskRule(String pattern) {
        this.maskRule = pattern != null && pattern.length() > 0 ? Pattern.compile(pattern) : null;
    }
}

