/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.terminology.simpletb;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String GLOSSARYPATH = "glossaryPath";
    private static final String SOURCELOCALE = "sourceLocale";
    private static final String TARGETLOCALE = "targetLocale";
    private String glossaryPath;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public String getGlossaryPath() {
        return this.glossaryPath;
    }

    public void setGlossaryPath(String glossaryPath) {
        this.glossaryPath = glossaryPath;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public void setSourceLocale(LocaleId locId) {
        this.sourceLocale = locId;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    public void setTargetLocale(LocaleId locId) {
        this.targetLocale = locId;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.glossaryPath = this.buffer.getString(GLOSSARYPATH, this.glossaryPath);
        this.sourceLocale = LocaleId.fromString(this.buffer.getString(SOURCELOCALE, this.sourceLocale.toString()));
        this.targetLocale = LocaleId.fromString(this.buffer.getString(TARGETLOCALE, this.targetLocale.toString()));
    }

    @Override
    public void reset() {
        this.glossaryPath = "";
        this.sourceLocale = LocaleId.ENGLISH;
        this.targetLocale = LocaleId.FRENCH;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(GLOSSARYPATH, this.glossaryPath);
        this.buffer.setString(SOURCELOCALE, this.sourceLocale.toString());
        this.buffer.setString(TARGETLOCALE, this.targetLocale.toString());
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(GLOSSARYPATH, "TBX document", "Full path of the TBX document");
        desc.add(SOURCELOCALE, "Source locale", "Locale identifier for the source");
        desc.add(TARGETLOCALE, "Target locale", "Locale identifier for the target");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("SimpleTB Connector Settings", true, false);
        desc.addPathInputPart(paramsDesc.get(GLOSSARYPATH), "TBX File", false);
        desc.addTextInputPart(paramsDesc.get(SOURCELOCALE));
        desc.addTextInputPart(paramsDesc.get(TARGETLOCALE));
        return desc;
    }
}

