/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.Serializable;
import net.sf.okapi.lib.xliff.InlineType;
import net.sf.okapi.lib.xliff.Util;

public class Code
implements Serializable {
    private static final long serialVersionUID = 64L;
    public static final int CANDELETE = 1;
    public static final int CANREPLICATE = 2;
    public static final int CANREORDER = 4;
    public static final int CANCHANGEPARENT = 8;
    String internalId;
    private InlineType inlineType;
    private String id;
    private String originalData;
    private int hints = 15;

    public Code(InlineType inlineType, String id, String originalData) {
        if (inlineType == null) {
            throw new RuntimeException("inline type cannot be null.");
        }
        if (id == null) {
            throw new RuntimeException("Code id cannot be null.");
        }
        this.inlineType = inlineType;
        this.id = id;
        this.internalId = Util.toInternalId(id, inlineType);
        this.originalData = originalData;
    }

    public String getOriginalData() {
        return this.originalData;
    }

    public void setOriginalData(String originalData) {
        this.originalData = originalData;
    }

    public boolean hasOriginalData() {
        return !Util.isNullOrEmpty(this.originalData);
    }

    public String getId() {
        return this.id;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public InlineType getInlineType() {
        return this.inlineType;
    }

    public void setInlineType(InlineType inlineType) {
        this.inlineType = inlineType;
    }

    public int getHints() {
        return this.hints;
    }

    public void setHints(int hints) {
        this.hints = hints;
    }

    public boolean canDelete() {
        return (this.hints & 1) == 1;
    }

    public void setCanDelete(boolean canDelete) {
        this.hints = canDelete ? (this.hints |= 1) : (this.hints &= 0xFFFFFFFE);
    }

    public boolean canReplicate() {
        return (this.hints & 2) == 2;
    }

    public void setCanReplicate(boolean canReplicate) {
        this.hints = canReplicate ? (this.hints |= 2) : (this.hints &= 0xFFFFFFFD);
    }

    public boolean canReorder() {
        return (this.hints & 4) == 4;
    }

    public void setCanReorder(boolean canReorder) {
        this.hints = canReorder ? (this.hints |= 4) : (this.hints &= 0xFFFFFFFB);
    }

    public boolean canChangeParent() {
        return (this.hints & 8) == 8;
    }

    public void setCanChangeParent(boolean canChangeParent) {
        this.hints = canChangeParent ? (this.hints |= 8) : (this.hints &= 0xFFFFFFF7);
    }
}

