/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff.Code;
import net.sf.okapi.lib.xliff.Codes;
import net.sf.okapi.lib.xliff.XLIFFReaderException;

public class CodeStore
implements Serializable {
    private static final long serialVersionUID = 64L;
    private Codes srcCodes;
    private Codes trgCodes;
    private transient Map<String, String> map;

    public boolean hasCodeWithOriginalData() {
        if (this.srcCodes != null && this.srcCodes.hasCodeWithOriginalData()) {
            return true;
        }
        return this.trgCodes != null && this.trgCodes.hasCodeWithOriginalData();
    }

    public boolean hasSourceCode() {
        return this.srcCodes != null && this.srcCodes.hasCode();
    }

    public boolean hasTargetCode() {
        return this.trgCodes != null && this.trgCodes.hasCode();
    }

    public Codes getSourceCodes() {
        if (this.srcCodes == null) {
            this.srcCodes = new Codes(this);
        }
        return this.srcCodes;
    }

    public Codes getTargetCodes() {
        if (this.trgCodes == null) {
            this.trgCodes = new Codes(this);
        }
        return this.trgCodes;
    }

    public void calculateOriginalDataToIdsMap() {
        String tmp;
        Code code;
        int i;
        this.map = new LinkedHashMap<String, String>();
        int mapId = 0;
        if (this.srcCodes != null) {
            for (i = 0; i < this.srcCodes.size(); ++i) {
                code = this.srcCodes.get(i);
                tmp = code.getOriginalData();
                if (tmp == null) {
                    tmp = "";
                }
                if (this.map.containsKey(tmp)) continue;
                this.map.put(code.getOriginalData(), "d" + String.valueOf(++mapId));
            }
        }
        if (this.trgCodes != null) {
            for (i = 0; i < this.trgCodes.size(); ++i) {
                code = this.trgCodes.get(i);
                tmp = code.getOriginalData();
                if (tmp == null) {
                    tmp = "";
                }
                if (this.map.containsKey(tmp)) continue;
                this.map.put(code.getOriginalData(), "d" + String.valueOf(++mapId));
            }
        }
    }

    public void setOutsideRepresentationMap(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, String> getOutsideRepresentationMap() {
        return this.map;
    }

    public String getIdForOriginalData(String originalData) {
        if (this.map == null) {
            throw new XLIFFReaderException("No original data map defined for this object.");
        }
        if (!this.map.containsKey(originalData)) {
            throw new XLIFFReaderException(String.format("No id found for the original data '%s'.", originalData));
        }
        return this.map.get(originalData);
    }

    public String getOriginalDataForId(String id) {
        if (this.map == null) {
            throw new XLIFFReaderException("No original data map defined for this object.");
        }
        if (!this.map.containsKey(id)) {
            throw new XLIFFReaderException(String.format("No original data found for the id '%s'.", id));
        }
        return this.map.get(id);
    }
}

