/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.Serializable;
import java.util.ArrayList;
import net.sf.okapi.lib.xliff.Code;
import net.sf.okapi.lib.xliff.CodeStore;
import net.sf.okapi.lib.xliff.InlineType;
import net.sf.okapi.lib.xliff.Util;

public class Codes
implements Serializable {
    private static final long serialVersionUID = 64L;
    private CodeStore store;
    private ArrayList<Code> codes;

    public Codes(CodeStore store) {
        this.store = store;
    }

    public boolean hasCode() {
        return this.codes != null && !this.codes.isEmpty();
    }

    public boolean hasCodeWithOriginalData() {
        if (this.codes != null) {
            for (Code code : this.codes) {
                if (!code.hasOriginalData()) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        if (this.codes == null) {
            return 0;
        }
        return this.codes.size();
    }

    public CodeStore getCodeStore() {
        return this.store;
    }

    public Code get(int index) {
        if (this.codes == null) {
            return null;
        }
        return this.codes.get(index);
    }

    public Code get(String id, InlineType type) {
        if (this.codes == null) {
            return null;
        }
        String tmp = Util.toInternalId(id, type);
        for (Code code : this.codes) {
            if (!code.internalId.equals(tmp)) continue;
            return code;
        }
        return null;
    }

    public void add(Code code) {
        if (this.codes == null) {
            this.codes = new ArrayList();
        }
        this.codes.add(code);
    }
}

