/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.Serializable;
import net.sf.okapi.lib.xliff.Code;
import net.sf.okapi.lib.xliff.CodeStore;
import net.sf.okapi.lib.xliff.Codes;
import net.sf.okapi.lib.xliff.InlineType;
import net.sf.okapi.lib.xliff.Util;

public class Fragment
implements Serializable {
    private static final long serialVersionUID = 64L;
    public static final int STYLE_XSDTEMP = -1;
    public static final int STYLE_NODATA = 0;
    public static final int STYLE_DATAINSIDE = 1;
    public static final int STYLE_DATAOUTSIDE = 2;
    public static final char MARKER_OPENING = '\ue101';
    public static final char MARKER_CLOSING = '\ue102';
    public static final char MARKER_PLACEHOLDER = '\ue103';
    public static final int CHARBASE = 57616;
    private StringBuilder ctext;
    private Codes codes;

    public static char toChar(int index) {
        return (char)(index + 57616);
    }

    public static int toIndex(char index) {
        return index - 57616;
    }

    public static boolean isMarker(char ch) {
        return ch == '\ue101' || ch == '\ue102' || ch == '\ue103';
    }

    public Fragment(CodeStore store) {
        this.ctext = new StringBuilder();
        if (store != null) {
            this.codes = store.getSourceCodes();
        }
    }

    public Fragment(CodeStore store, boolean target) {
        this.ctext = new StringBuilder();
        if (store != null) {
            this.codes = target ? store.getTargetCodes() : store.getSourceCodes();
        }
    }

    public Fragment(CodeStore store, boolean target, String plainText) {
        this.ctext = new StringBuilder(plainText);
        if (store != null) {
            this.codes = target ? store.getTargetCodes() : store.getSourceCodes();
        }
    }

    public String getString(int style) {
        switch (style) {
            case -1: {
                return this.getStringXSDTemp();
            }
            case 1: {
                return this.getStringWithOriginalData(true);
            }
            case 2: {
                return this.getStringWithOriginalData(false);
            }
        }
        return this.toString();
    }

    public CodeStore getCodeStore() {
        return this.codes.getCodeStore();
    }

    private String getStringXSDTemp() {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (this.ctext.charAt(i) == '\ue101') {
                tmp.append(String.format("<inline id=\"%s\"/>", this.codes.get(Fragment.toIndex(this.ctext.charAt(++i))).getInternalId()));
                continue;
            }
            if (this.ctext.charAt(i) == '\ue102') {
                tmp.append(String.format("<inline id=\"%s\"/>", this.codes.get(Fragment.toIndex(this.ctext.charAt(++i))).getInternalId()));
                continue;
            }
            if (this.ctext.charAt(i) == '\ue103') {
                tmp.append(String.format("<inline id=\"%s\"/>", this.codes.get(Fragment.toIndex(this.ctext.charAt(++i))).getInternalId()));
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block5;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block5;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public String getStringWithOriginalData(boolean dataInside) {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.ctext.length(); ++i) {
            Code code;
            int index;
            char ch = this.ctext.charAt(i);
            if (this.ctext.charAt(i) == '\ue101') {
                index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<sc id=\"%s\"", code.getId()));
                if (dataInside) {
                    if (Util.isNullOrEmpty(code.getOriginalData())) {
                        tmp.append("/>");
                        continue;
                    }
                    tmp.append(">" + Util.toXML(code.getOriginalData(), false) + "</sc>");
                    continue;
                }
                if (code.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.codes.getCodeStore().getIdForOriginalData(code.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            if (this.ctext.charAt(i) == '\ue102') {
                index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<ec rid=\"%s\"", code.getId()));
                if (dataInside) {
                    if (Util.isNullOrEmpty(code.getOriginalData())) {
                        tmp.append("/>");
                        continue;
                    }
                    tmp.append(">" + Util.toXML(code.getOriginalData(), false) + "</ec>");
                    continue;
                }
                if (code.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.codes.getCodeStore().getIdForOriginalData(code.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            if (this.ctext.charAt(i) == '\ue103') {
                index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<ph id=\"%s\"", code.getId()));
                if (dataInside) {
                    if (Util.isNullOrEmpty(code.getOriginalData())) {
                        tmp.append("/>");
                        continue;
                    }
                    tmp.append(">" + Util.toXML(code.getOriginalData(), false) + "</ph>");
                    continue;
                }
                if (code.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.codes.getCodeStore().getIdForOriginalData(code.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block5;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block5;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (this.ctext.charAt(i) == '\ue101') {
                tmp.append(String.format("<pc id=\"%s\">", this.codes.get(Fragment.toIndex(this.ctext.charAt(++i))).getId()));
                continue;
            }
            if (this.ctext.charAt(i) == '\ue102') {
                tmp.append("</pc>");
                ++i;
                continue;
            }
            if (this.ctext.charAt(i) == '\ue103') {
                tmp.append(String.format("<ph id=\"%s\"/>", this.codes.get(Fragment.toIndex(this.ctext.charAt(++i))).getId()));
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block5;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block5;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block5;
                }
                default: {
                    tmp.append(ch);
                }
            }
        }
        return tmp.toString();
    }

    public boolean isEmpty() {
        return this.ctext.length() == 0;
    }

    public void append(String plainText) {
        this.ctext.append(plainText);
    }

    public void append(char ch) {
        this.ctext.append(ch);
    }

    public Code append(InlineType type, String id, String originalData) {
        if (this.codes == null) {
            throw new RuntimeException("Cannot add codes in this fragment because it has no associated store of codes.");
        }
        Code code = new Code(type, id, originalData);
        this.codes.add(code);
        switch (type) {
            case OPENING: {
                this.ctext.append("\ue101" + Fragment.toChar(this.codes.size() - 1));
                break;
            }
            case CLOSING: {
                this.ctext.append("\ue102" + Fragment.toChar(this.codes.size() - 1));
                break;
            }
            case PLACEHOLDER: {
                this.ctext.append("\ue103" + Fragment.toChar(this.codes.size() - 1));
            }
        }
        return code;
    }
}

