/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.Serializable;
import net.sf.okapi.lib.xliff.CodeStore;
import net.sf.okapi.lib.xliff.Fragment;

public class Part
implements Serializable {
    private static final long serialVersionUID = 64L;
    protected CodeStore store;
    protected Fragment source;
    protected Fragment target;
    protected int targetOrder;

    public Part(CodeStore store) {
        this.store = store;
        this.source = new Fragment(store);
    }

    public Part(CodeStore store, String sourceContent) {
        this.store = store;
        this.source = new Fragment(store, false, sourceContent);
    }

    public Fragment getSource() {
        return this.source;
    }

    public void setSource(Fragment fragment) {
        if (this.store != fragment.getCodeStore()) {
            throw new RuntimeException("The fragment passed in setSource must use the same codes store.");
        }
        this.source = fragment;
    }

    public void setSource(String plainText) {
        this.source = new Fragment(this.store, false, plainText);
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public Fragment getTarget(boolean createIfNeeded) {
        if (this.target == null && createIfNeeded) {
            this.target = new Fragment(this.store, true);
        }
        return this.target;
    }

    public void setTarget(Fragment fragment) {
        if (this.store != fragment.getCodeStore()) {
            throw new RuntimeException("The fragment passed in setTarget must use the same codes store.");
        }
        this.target = fragment;
    }

    public void setTarget(String plainText) {
        this.target = new Fragment(this.store, true, plainText);
    }

    public void setTargetOrder(int targetOrder) {
        this.targetOrder = targetOrder;
    }

    public CodeStore getCodeStore() {
        return this.store;
    }
}

