/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.lib.xliff.Candidate;
import net.sf.okapi.lib.xliff.Code;
import net.sf.okapi.lib.xliff.CodeStore;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.GroupData;
import net.sf.okapi.lib.xliff.InlineType;
import net.sf.okapi.lib.xliff.Note;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.SectionData;
import net.sf.okapi.lib.xliff.Segment;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.Util;
import net.sf.okapi.lib.xliff.XLIFFEvent;
import net.sf.okapi.lib.xliff.XLIFFReaderException;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.IWithNotes;

public class XLIFFReader {
    private XMLStreamReader reader;
    private boolean hasNext;
    private LinkedList<XLIFFEvent> queue;
    private SectionData sectionData;
    private Stack<GroupData> groups;
    private Unit unit;
    private Segment segment;
    private Part ignorable;

    public void open(URI inputURI) {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputURI.toURL().openStream());
            this.open(bis);
        }
        catch (MalformedURLException e) {
            throw new XLIFFReaderException("Cannot open the XLIFF stream. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XLIFFReaderException("Cannot open the XLIFF stream. " + e.getMessage(), e);
        }
    }

    public void open(String input) {
        this.open(new ByteArrayInputStream(input.getBytes()));
    }

    public void open(InputStream inputStream) {
        try {
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            this.reader = fact.createXMLStreamReader(inputStream);
            this.queue = new LinkedList();
            this.groups = new Stack();
            this.hasNext = true;
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Cannot open the XLIFF stream. " + e.getMessage(), e);
        }
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Closing error. " + e.getMessage(), e);
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public XLIFFEvent next() {
        if (this.queue.isEmpty()) {
            this.readNext();
        }
        if (this.queue.peek().getType() == XLIFFEvent.XLIFFEventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    private void readNext() {
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                switch (type) {
                    case 7: {
                        break;
                    }
                    case 8: {
                        this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.END_DOCUMENT, null));
                        return;
                    }
                    case 1: {
                        String tmp = this.reader.getLocalName();
                        if (tmp.equals("unit")) {
                            this.processUnit();
                            return;
                        }
                        if (tmp.equals("group")) {
                            this.processStartGroup();
                            return;
                        }
                        if (tmp.equals("file")) {
                            this.processStartSection();
                            return;
                        }
                        if (!tmp.equals("xliff")) break;
                        this.processXliff();
                        return;
                    }
                    case 2: {
                        String tmp = this.reader.getLocalName();
                        if (tmp.equals("group")) {
                            this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.END_GROUP, this.groups.pop()));
                            return;
                        }
                        if (!tmp.equals("file")) break;
                        this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.END_SECTION, this.sectionData));
                        return;
                    }
                }
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new XLIFFReaderException("Reading error. " + e.getMessage(), e);
        }
    }

    private void processXliff() {
        String tmp = this.reader.getAttributeValue(null, "version");
        this.cannotBeNullOrEmpty("version", tmp);
        if (!tmp.equals("2.0")) {
            throw new XLIFFReaderException("Not a 2.0 XLIFF document.");
        }
        this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.START_DOCUMENT, null));
    }

    private void processStartSection() {
        this.sectionData = new SectionData("sectionId");
        String tmp = this.reader.getAttributeValue(null, "original");
        if (this.cannotBeEmpty("original", tmp)) {
            this.sectionData.setOriginal(tmp);
        }
        tmp = this.reader.getAttributeValue(null, "srclang");
        this.cannotBeNullOrEmpty("srclang", tmp);
        this.sectionData.setSourceLanguage(tmp);
        tmp = this.reader.getAttributeValue(null, "tgtlang");
        if (this.cannotBeEmpty("tgtlang", tmp)) {
            this.sectionData.setTargetLanguage(tmp);
        }
        this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.START_SECTION, this.sectionData));
    }

    private void processStartGroup() {
        String tmp = this.reader.getAttributeValue(null, "id");
        this.cannotBeEmpty("id", tmp);
        GroupData gd = new GroupData(tmp);
        tmp = this.reader.getAttributeValue(null, "type");
        if (this.cannotBeEmpty("type", tmp)) {
            gd.setType(tmp);
        }
        this.groups.push(gd);
        this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.START_SECTION, gd));
    }

    private void cannotBeNullOrEmpty(String name, String value) {
        if (Util.isNullOrEmpty(value)) {
            throw new XLIFFReaderException(String.format("Missing or empty attribute '%s'", name));
        }
    }

    private boolean cannotBeEmpty(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            throw new XLIFFReaderException(String.format("Empty attribute '%s'", name));
        }
        return true;
    }

    private boolean mustBeYesOrNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            throw new XLIFFReaderException(String.format("Invalid attribute value for '%s' (must be 'yes' or 'no')", name));
        }
        return true;
    }

    private void processUnit() throws XMLStreamException {
        String tmp = this.reader.getAttributeValue(null, "id");
        this.cannotBeNullOrEmpty("id", tmp);
        this.unit = new Unit(tmp);
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    if (tmp.equals("segment")) {
                        this.processPart(true);
                        break;
                    }
                    if (tmp.equals("ignorable")) {
                        this.processPart(false);
                        break;
                    }
                    if (tmp.equals("originalData")) {
                        this.processOriginalData(this.unit.getCodeStore());
                        break;
                    }
                    if (tmp.equals("match")) {
                        this.processCandidate(this.unit);
                        break;
                    }
                    if (!tmp.equals("simpleNote")) break;
                    this.processNote(this.unit);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    if (!tmp.equals("unit")) break;
                    this.queue.add(new XLIFFEvent(XLIFFEvent.XLIFFEventType.EXTRACTION_UNIT, this.unit));
                    return;
                }
            }
        }
    }

    private void processCandidate(IWithCandidates parent) throws XMLStreamException {
        Candidate alt = new Candidate();
        Part part = new Part(alt.getCodeStore());
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    String tmp = this.reader.getLocalName();
                    if (tmp.equals("source")) {
                        this.processContent(part);
                        alt.setSource(part.getSource());
                        break;
                    }
                    if (tmp.equals("target")) {
                        this.processContent(part);
                        alt.setTarget(part.getTarget(false));
                        break;
                    }
                    if (!tmp.equals("originalData")) break;
                    this.processOriginalData(alt.getCodeStore());
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    if (!tmp.equals("match")) break;
                    parent.addCandidate(alt);
                    return;
                }
            }
        }
    }

    private void processNote(IWithNotes parent) throws XMLStreamException {
        INote.AppliesTo at = INote.AppliesTo.DEFAULT;
        String tmp = this.reader.getAttributeValue(null, "appliesTo");
        if (this.cannotBeEmpty("appliesTo", tmp)) {
            if (tmp.equals("source")) {
                at = INote.AppliesTo.SOURCE;
            } else if (tmp.equals("target")) {
                at = INote.AppliesTo.TARGET;
            } else {
                throw new XLIFFReaderException(String.format("Invalid appliesTo value ('%s').", tmp));
            }
        }
        StringBuilder sb = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    sb.append(this.reader.getText());
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    if (!tmp.equals("simpleNote")) break;
                    Note note = new Note(sb.toString(), at);
                    parent.addNote(note);
                    return;
                }
            }
        }
    }

    private void processOriginalData(CodeStore store) throws XMLStreamException {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder content = new StringBuilder();
        String id = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (id == null) break;
                    content.append(this.reader.getText());
                    break;
                }
                case 1: {
                    String tmp = this.reader.getLocalName();
                    if (!tmp.equals("data")) break;
                    id = this.reader.getAttributeValue(null, "id");
                    this.cannotBeNullOrEmpty("id", id);
                    if (map.containsKey(id)) {
                        throw new XLIFFReaderException(String.format("Duplicated id ('%s') in original data table.", id));
                    }
                    content.setLength(0);
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    if (tmp.equals("data")) {
                        map.put(id, content.toString());
                        id = null;
                        break;
                    }
                    if (!tmp.equals("originalData")) break;
                    store.setOutsideRepresentationMap(map);
                    return;
                }
            }
        }
    }

    private void processPart(boolean isSegment) throws XMLStreamException {
        String tmp;
        if (isSegment) {
            this.segment = this.unit.appendNewSegment();
            tmp = this.reader.getAttributeValue(null, "id");
            if (this.cannotBeEmpty("id", tmp)) {
                this.segment.setId(tmp);
            }
            if (this.mustBeYesOrNo("translatable", tmp = this.reader.getAttributeValue(null, "translatable"))) {
                this.segment.setTranslatable(tmp.equals("yes"));
            }
        } else {
            this.ignorable = this.unit.appendNewIgnorable();
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    if (tmp.equals("source")) {
                        if (isSegment) {
                            this.processContent(this.segment);
                            break;
                        }
                        this.processContent(this.ignorable);
                        break;
                    }
                    if (tmp.equals("target")) {
                        if (isSegment) {
                            this.processContent(this.segment);
                        } else {
                            this.processContent(this.ignorable);
                        }
                        if (this.sectionData.getTargetLanguage() != null) break;
                        throw new XLIFFReaderException("No target language defined in a file with a target entry.");
                    }
                    if (tmp.equals("match")) {
                        this.processCandidate(this.segment);
                        break;
                    }
                    if (!tmp.equals("simpleNote")) break;
                    this.processNote(this.segment);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    if (tmp.equals("segment")) {
                        return;
                    }
                    if (!tmp.equals("ignorable")) break;
                    return;
                }
            }
        }
    }

    private void processContent(Part partToFill) throws XMLStreamException {
        Fragment frag = new Fragment(partToFill.getCodeStore());
        Code code = null;
        StringBuilder content = new StringBuilder();
        String nid = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (code == null) {
                        frag.append(this.reader.getText());
                        break;
                    }
                    content.append(this.reader.getText());
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 1: {
                    String tmp = this.reader.getLocalName();
                    if (tmp.equals("sc")) {
                        tmp = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", tmp);
                        code = frag.append(InlineType.OPENING, tmp, null);
                        content.setLength(0);
                    } else if (tmp.equals("ec")) {
                        tmp = this.reader.getAttributeValue(null, "rid");
                        this.cannotBeNullOrEmpty("rid", tmp);
                        code = frag.append(InlineType.CLOSING, tmp, null);
                        content.setLength(0);
                    } else if (tmp.equals("ph")) {
                        tmp = this.reader.getAttributeValue(null, "id");
                        this.cannotBeNullOrEmpty("id", tmp);
                        code = frag.append(InlineType.PLACEHOLDER, tmp, null);
                        content.setLength(0);
                    }
                    if (code == null || !this.cannotBeEmpty("nid", tmp = this.reader.getAttributeValue(null, "nid"))) break;
                    code.setOriginalData(partToFill.getCodeStore().getOriginalDataForId(tmp));
                    nid = tmp;
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    if (tmp.equals("sc") || tmp.equals("ec") || tmp.equals("ph")) {
                        if (this.checkInsideVersusOutside(nid, content, code)) {
                            code.setOriginalData(content.toString());
                        }
                        code = null;
                        nid = null;
                        break;
                    }
                    if (tmp.equals("source")) {
                        partToFill.setSource(frag);
                        return;
                    }
                    if (!tmp.equals("target")) break;
                    partToFill.setTarget(frag);
                    return;
                }
            }
        }
    }

    private boolean checkInsideVersusOutside(String outsideId, StringBuilder insideContent, Code code) {
        if (insideContent.length() > 0 && outsideId != null) {
            throw new XLIFFReaderException(String.format("Code id='%s' cannot have both content and outside reference ('%s') defined.", code.getId(), outsideId));
        }
        return outsideId == null;
    }
}

