/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import net.sf.okapi.lib.xliff.CodeStore;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.GroupData;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.Res;
import net.sf.okapi.lib.xliff.SectionData;
import net.sf.okapi.lib.xliff.Segment;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.Util;
import net.sf.okapi.lib.xliff.XLIFFEvent;
import net.sf.okapi.lib.xliff.XLIFFWriterException;
import org.oasisopen.xliff.v2.ICandidate;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.IWithNotes;

public class XLIFFWriter {
    private PrintWriter writer = null;
    private String lb = System.getProperty("line.separator");
    private boolean isIndented = false;
    private String indent;
    private boolean inDocument;
    private boolean inFile;
    private int style = 0;
    private String sourceLang;
    private String targetLang;

    public void create(File file, String sourceLang) {
        try {
            String path = file.getCanonicalPath();
            int n = path.lastIndexOf(92);
            if (n == -1) {
                path.lastIndexOf(47);
            }
            if (n > -1) {
                File dir = new File(path.substring(0, n));
                dir.mkdirs();
            }
            this.create(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"), sourceLang);
        }
        catch (FileNotFoundException e) {
            throw new XLIFFWriterException(Res.t("cantCreateDocument"), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XLIFFWriterException("Unsupported encoding.", e);
        }
        catch (IOException e) {
            throw new XLIFFWriterException(Res.t("cantCreateDocument"), e);
        }
    }

    public void create(Writer output, String sourceLang) {
        this.setLanguages(sourceLang, null);
        this.writer = new PrintWriter(output);
        this.indent = "";
        this.inFile = false;
        this.inDocument = false;
    }

    public void setLanguages(String sourceLang, String targetLang) {
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
    }

    public void setInlineStyle(int style) {
        switch (style) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.style = style;
                return;
            }
        }
        throw new XLIFFWriterException(String.format(Res.t("badInlineStyle"), style));
    }

    public int getInlineStyle() {
        return this.style;
    }

    public void setLineBreak(String lineBreak) {
        this.lb = lineBreak;
    }

    public String getLineBreak() {
        return this.lb;
    }

    public void setIsIndented(boolean isIndented) {
        this.isIndented = isIndented;
    }

    public boolean getIsIndented() {
        return this.isIndented;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void writeEvent(XLIFFEvent event) {
        switch (event.getType()) {
            case START_DOCUMENT: {
                break;
            }
            case START_SECTION: {
                SectionData sd = event.getSectionData();
                this.setLanguages(sd.getSourceLanguage(), sd.getTargetLanguage());
                break;
            }
            case START_GROUP: {
                this.writeStartGroup(event.getGroupData());
                break;
            }
            case EXTRACTION_UNIT: {
                this.writeUnit(event.getUnit());
                break;
            }
            case END_GROUP: {
                this.writeEndGroup();
                break;
            }
            case END_SECTION: {
                this.writeEndFile();
                break;
            }
            case END_DOCUMENT: {
                this.writeEndDocument();
            }
        }
    }

    public void writeUnit(Unit unit) {
        if (unit.getPartCount() == 0) {
            return;
        }
        if (!this.inFile) {
            this.writeStartFile();
        }
        this.writer.print(this.indent + String.format("<unit id=\"%s\"", Util.toXML(unit.getId(), true)));
        this.writer.print(">" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        if (this.style == 2) {
            this.writeOriginalData(unit.getCodeStore());
        }
        for (Part part : unit) {
            Segment seg = null;
            if (part instanceof Segment) {
                seg = (Segment)part;
                this.writer.print(this.indent + "<" + "segment" + ">" + this.lb);
            } else {
                this.writer.print(this.indent + "<" + "ignorable" + ">" + this.lb);
            }
            if (this.isIndented) {
                this.indent = this.indent + " ";
            }
            this.writeFragment("source", part.getSource(), 0);
            if (part.hasTarget()) {
                this.writeFragment("target", part.getTarget(true), part.targetOrder);
            }
            if (seg != null) {
                this.writeNotes(seg);
                this.writeCandidates(seg);
            }
            if (this.isIndented) {
                this.indent = this.indent.substring(1);
            }
            if (seg != null) {
                this.writer.print(this.indent + "</segment>" + this.lb);
                continue;
            }
            this.writer.print(this.indent + "</ignorable>" + this.lb);
        }
        this.writeNotes(unit);
        this.writeCandidates(unit);
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</unit>" + this.lb);
    }

    private void writeCandidates(IWithCandidates parent) {
        if (parent.getCandidates().size() == 0) {
            return;
        }
        this.writer.print(this.indent + "<matches>" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        for (ICandidate alt : parent.getCandidates()) {
            this.writer.print(this.indent + "<match>" + this.lb);
            if (this.isIndented) {
                this.indent = this.indent + " ";
            }
            if (this.style == 2) {
                this.writeOriginalData(alt.getCodeStore());
            }
            this.writeFragment("source", alt.getSource(), -1);
            this.writeFragment("target", alt.getTarget(), -1);
            if (this.isIndented) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + "</match>" + this.lb);
        }
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</matches>" + this.lb);
    }

    private void writeNotes(IWithNotes parent) {
        if (parent.getNoteCount() == 0) {
            return;
        }
        this.writer.print(this.indent + "<notes>" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        for (INote note : parent.getNotes()) {
            this.writer.print(this.indent + "<simpleNote");
            switch (note.getAppliesTo()) {
                case SOURCE: {
                    this.writer.print(" appliesTo=\"source\"");
                    break;
                }
                case TARGET: {
                    this.writer.print(" appliesTo=\"target\"");
                    break;
                }
            }
            this.writer.print(">" + Util.toXML(note.getText(), false));
            this.writer.print("</simpleNote>" + this.lb);
        }
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</notes>" + this.lb);
    }

    public void writeStartDocument(String extraAttributes, String comment) {
        this.writer.print("<?xml version=\"1.0\"?>" + this.lb);
        this.writer.print("<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\"");
        if (!Util.isNullOrEmpty(extraAttributes)) {
            this.writer.print(this.lb + extraAttributes);
        }
        this.writer.print(">" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        this.inDocument = true;
        if (!Util.isNullOrEmpty(comment)) {
            this.writer.print(this.indent + "<!-- " + Util.toXML(comment, false) + "-->" + this.lb);
        }
    }

    public void writeEndDocument() {
        if (this.inFile) {
            this.writeEndFile();
        }
        if (this.inDocument) {
            if (this.isIndented) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print("</xliff>" + this.lb);
        }
    }

    public void writeStartFile() {
        if (!this.inDocument) {
            this.writeStartDocument(null, null);
        }
        this.writer.print(this.indent + String.format("<%s %s=\"%s\"", "file", "srclang", this.sourceLang));
        if (!Util.isNullOrEmpty(this.targetLang)) {
            this.writer.print(String.format(" %s=\"%s\"", "tgtlang", this.targetLang));
        }
        this.writer.print(">" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        this.inFile = true;
    }

    public void writeEndFile() {
        if (this.inFile) {
            if (this.isIndented) {
                this.indent = this.indent.substring(1);
            }
            this.writer.print(this.indent + "</file>" + this.lb);
            this.inFile = false;
        }
    }

    public void writeStartGroup(GroupData groupData) {
        if (!this.inFile) {
            this.writeStartFile();
        }
        this.writer.print(this.indent + "<" + "group");
        if (groupData != null) {
            this.writer.print(String.format(" %s=\"%s\"", "id", groupData.getId()));
        }
        this.writer.print(">" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
    }

    public void writeEndGroup() {
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "group" + ">" + this.lb);
    }

    private void writeFragment(String name, Fragment fragment, int order) {
        if (order > 0) {
            this.writer.print(this.indent + String.format("<%s order=\"%d\">", name, order));
        } else {
            this.writer.print(this.indent + "<" + name + ">");
        }
        this.writer.print(fragment.getString(this.style));
        this.writer.print("</" + name + ">" + this.lb);
    }

    private void writeOriginalData(CodeStore store) {
        if (!store.hasCodeWithOriginalData()) {
            return;
        }
        store.calculateOriginalDataToIdsMap();
        Map<String, String> map = store.getOutsideRepresentationMap();
        this.writer.print(this.indent + "<" + "originalData" + ">" + this.lb);
        if (this.isIndented) {
            this.indent = this.indent + " ";
        }
        for (String originalData : map.keySet()) {
            String id = map.get(originalData);
            this.writer.print(this.indent + String.format("<%s %s=\"%s\">", "data", "id", id));
            this.writer.print(Util.toXML(originalData, false));
            this.writer.print("</data>" + this.lb);
        }
        if (this.isIndented) {
            this.indent = this.indent.substring(1);
        }
        this.writer.print(this.indent + "</" + "originalData" + ">" + this.lb);
        store.setOutsideRepresentationMap(map);
    }
}

