/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

class SimpleStore {
    DataOutputStream dos = null;
    DataInputStream dis = null;

    SimpleStore() {
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
                this.dis = null;
            }
            if (this.dos != null) {
                this.dos.close();
                this.dos = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing.", e);
        }
    }

    public void create(File file) {
        try {
            this.close();
            this.dos = new DataOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating.", e);
        }
    }

    public void openForRead(File file) {
        try {
            this.close();
            this.dis = new DataInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening.", e);
        }
    }

    public void write(TextFragment tf) {
        try {
            this.dos.writeUTF(tf.getCodedText());
            this.dos.writeUTF(Code.codesToString(tf.getCodes()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing.", e);
        }
    }

    public TextFragment readNext() {
        try {
            String codedText = this.dis.readUTF();
            String tmp = this.dis.readUTF();
            TextFragment tf = new TextFragment(codedText, Code.stringToCodes(tmp));
            return tf;
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading.", e);
        }
    }
}

