/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.msbatchtranslation;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.connectors.microsoft.MicrosoftMTConnector;
import net.sf.okapi.steps.msbatchtranslation.Parameters;

@UsingParameters(value=Parameters.class)
public class MSBatchTranslationStep
extends BasePipelineStep {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int MAXEVENTS = 20;
    private Parameters params = new Parameters();
    private TMXWriter tmxWriter;
    private LinkedList<Event> events;
    private int maxEvents = 20;
    private MicrosoftMTConnector conn;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private String rootDir;
    private Map<String, String> attributes;
    private boolean needReset;

    private void closeAndClean() {
        if (this.tmxWriter != null) {
            this.tmxWriter.writeEndDocument();
            this.tmxWriter.close();
            this.tmxWriter = null;
        }
        if (this.events != null) {
            this.events.clear();
            this.events = null;
        }
    }

    @Override
    public String getDescription() {
        return "Annotates text units with Microsoft Translator matches or/and creates a TM from them. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Microsoft Batch Translation";
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.events = new LinkedList();
        this.maxEvents = this.params.getMaxEvents();
        if (this.maxEvents < 1 || this.maxEvents > 1000) {
            this.maxEvents = 20;
        }
        this.conn = new MicrosoftMTConnector();
        net.sf.okapi.connectors.microsoft.Parameters prm = (net.sf.okapi.connectors.microsoft.Parameters)this.conn.getParameters();
        prm.setAppId(this.params.getAppId());
        this.conn.setLanguages(this.sourceLocale, this.targetLocale);
        this.conn.setMaximumHits(this.params.getMaxMatches());
        this.conn.setThreshold(this.params.getThreshold());
        if (this.params.getMakeTmx()) {
            String tmxOutputPath = Util.fillRootDirectoryVariable(this.params.getTmxPath(), this.rootDir);
            tmxOutputPath = LocaleId.replaceVariables(tmxOutputPath, this.sourceLocale, this.targetLocale);
            this.tmxWriter = new TMXWriter(tmxOutputPath);
            this.tmxWriter.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getCanonicalName(), "1", "sentence", null, "unknown");
            this.attributes = new Hashtable<String, String>();
            if (this.params.getMarkAsMT()) {
                this.attributes.put("creationid", "MT!");
            }
            this.attributes.put("Txt::Origin", "Microsoft-Translator");
        }
        return event;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                return this.handleStartBatch(event);
            }
            case TEXT_UNIT: 
            case DOCUMENT_PART: 
            case START_GROUP: 
            case END_GROUP: {
                return this.storeAndPossiblyProcess(event, false);
            }
            case CUSTOM: 
            case MULTI_EVENT: 
            case START_SUBDOCUMENT: 
            case END_DOCUMENT: 
            case END_SUBDOCUMENT: {
                return this.storeAndPossiblyProcess(event, true);
            }
            case CANCELED: 
            case END_BATCH: {
                this.closeAndClean();
                break;
            }
        }
        return event;
    }

    private Event processEvents() {
        this.getTranslations();
        this.needReset = true;
        return new Event(EventType.MULTI_EVENT, new MultiEvent(this.events));
    }

    private Event storeAndPossiblyProcess(Event event, boolean mustProcess) {
        if (this.needReset) {
            this.needReset = false;
            this.events.clear();
        }
        this.events.add(event);
        if (mustProcess || this.events.size() >= this.maxEvents) {
            return this.processEvents();
        }
        return Event.NOOP_EVENT;
    }

    private void getTranslations() {
        if (this.events.isEmpty()) {
            return;
        }
        ArrayList<TextFragment> fragments = new ArrayList<TextFragment>();
        ArrayList<String> segIds = new ArrayList<String>();
        ArrayList<String> tuIds = new ArrayList<String>();
        for (Event event : this.events) {
            ITextUnit tu;
            if (!event.isTextUnit() || !(tu = event.getTextUnit()).isTranslatable()) continue;
            TextContainer trgCont = tu.getTarget(this.targetLocale);
            if (tu.getSource().hasBeenSegmented()) {
                ISegments trgSegs = null;
                if (trgCont != null) {
                    trgSegs = trgCont.getSegments();
                }
                for (Segment srcSeg : tu.getSourceSegments()) {
                    if (!srcSeg.text.hasText() || this.params.getOnlyWhenWithoutCandidate() && this.hasExistingCandidate(srcSeg, trgSegs)) continue;
                    fragments.add(srcSeg.text);
                    tuIds.add(tu.getId());
                    segIds.add(tu.getId() + "\f" + srcSeg.getId());
                }
                continue;
            }
            TextFragment srcFrag = tu.getSource().getFirstContent();
            if (!srcFrag.hasText() || this.params.getOnlyWhenWithoutCandidate() && this.hasExistingCandidate(trgCont)) continue;
            fragments.add(srcFrag);
            tuIds.add(tu.getId());
            segIds.add(null);
        }
        if (fragments.isEmpty()) {
            return;
        }
        List<List<QueryResult>> list = this.conn.queryList(fragments);
        if (Util.isEmpty(list)) {
            this.logger.warning("No translation generated.");
            return;
        }
        int entryIndex = 0;
        for (Event event : this.events) {
            ITextUnit tu;
            if (!event.isTextUnit() || !(tu = event.getTextUnit()).isTranslatable() || !((String)tuIds.get(entryIndex)).equals(tu.getId())) continue;
            TextContainer trgCont = tu.getTarget(this.targetLocale);
            if (tu.getSource().hasBeenSegmented()) {
                for (Segment srcSeg : tu.getSourceSegments()) {
                    if (!((String)segIds.get(entryIndex)).equals(tu.getId() + "\f" + srcSeg.getId())) continue;
                    List<QueryResult> resList = list.get(entryIndex);
                    ++entryIndex;
                    boolean firstMatch = true;
                    for (QueryResult res : resList) {
                        if (this.tmxWriter != null) {
                            this.tmxWriter.writeTU(res.source, res.target, null, this.attributes);
                        }
                        boolean fill = false;
                        if (firstMatch && this.params.getFillTarget()) {
                            boolean bl = fill = res.score >= this.params.getFillTargetThreshold();
                        }
                        if (fill || this.params.getAnnotate()) {
                            Segment trgSeg;
                            if (trgCont == null) {
                                trgCont = tu.createTarget(this.targetLocale, false, 4);
                            }
                            if ((trgSeg = trgCont.getSegments().get(srcSeg.id)) == null) {
                                trgSeg = new Segment(srcSeg.id);
                                trgCont.getSegments().append(trgSeg);
                            }
                            if (this.params.getAnnotate()) {
                                TextUnitUtil.addAltTranslation(trgSeg, res.toAltTranslation(srcSeg.text, this.sourceLocale, this.targetLocale));
                            }
                            if (fill && trgSeg.text.isEmpty()) {
                                trgSeg.text = res.target;
                            }
                        }
                        firstMatch = false;
                    }
                }
                continue;
            }
            List<QueryResult> resList = list.get(entryIndex);
            ++entryIndex;
            boolean firstMatch = true;
            for (QueryResult res : resList) {
                if (this.tmxWriter != null) {
                    this.tmxWriter.writeTU(res.source, res.target, null, this.attributes);
                }
                boolean fill = false;
                if (firstMatch && this.params.getFillTarget()) {
                    boolean bl = fill = res.score >= this.params.getFillTargetThreshold();
                }
                if (fill || this.params.getAnnotate()) {
                    TextFragment trgFrag;
                    if (trgCont == null) {
                        trgCont = tu.createTarget(this.targetLocale, false, 4);
                    }
                    if (this.params.getAnnotate()) {
                        TextFragment srcFrag = tu.getSource().getFirstContent();
                        TextUnitUtil.addAltTranslation(trgCont, res.toAltTranslation(srcFrag, this.sourceLocale, this.targetLocale));
                    }
                    if (fill && (trgFrag = trgCont.getFirstContent()).isEmpty()) {
                        trgFrag = res.target;
                    }
                }
                firstMatch = false;
            }
        }
    }

    private boolean hasExistingCandidate(Segment srcSeg, ISegments trgSegs) {
        if (trgSegs == null) {
            return false;
        }
        Segment trgSeg = trgSegs.get(srcSeg.getId());
        if (trgSeg == null) {
            return false;
        }
        AltTranslationsAnnotation ann = trgSeg.getAnnotation(AltTranslationsAnnotation.class);
        if (ann == null) {
            return false;
        }
        return ann.getFirst() != null;
    }

    private boolean hasExistingCandidate(TextContainer frag) {
        if (frag == null) {
            return false;
        }
        AltTranslationsAnnotation ann = frag.getAnnotation(AltTranslationsAnnotation.class);
        if (ann == null) {
            return false;
        }
        return ann.getFirst() != null;
    }
}

