/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.po;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.po.POFilterWriter;
import net.sf.okapi.filters.po.Parameters;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;

public class POPackageWriter
extends BasePackageWriter {
    private POFilterWriter writer;

    public POPackageWriter() {
        super("po");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, true);
        this.setTMXInfo(true, null, null, null, null, true);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new POFilterWriter();
        Parameters params = (Parameters)this.writer.getParameters();
        params.setOutputGeneric(true);
        this.writer.setMode(true, false, true);
        this.writer.setOptions(this.manifest.getTargetLocale(), "UTF-8");
        MergingInfo item = this.manifest.getItem(this.docId);
        String path = this.manifest.getSourceDirectory() + item.getRelativeInputPath() + ".po";
        this.writer.setOutput(path);
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndDocument(Event event) {
        this.writer.handleEvent(event);
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        super.processEndDocument(event);
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return;
        }
        this.writer.handleEvent(event);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

