/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    static final String PRESERVESEGMENTATION = "preserveSegmentation";
    static final String RETURNRAWDOCUMENT = "returnRawDocument";
    private boolean preserveSegmentation;
    private boolean returnRawDocument;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.preserveSegmentation = false;
        this.returnRawDocument = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.preserveSegmentation = this.buffer.getBoolean(PRESERVESEGMENTATION, this.preserveSegmentation);
        this.returnRawDocument = this.buffer.getBoolean(RETURNRAWDOCUMENT, this.returnRawDocument);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setParameter(PRESERVESEGMENTATION, this.preserveSegmentation);
        this.buffer.setParameter(RETURNRAWDOCUMENT, this.returnRawDocument);
        return this.buffer.toString();
    }

    public boolean getPreserveSegmentation() {
        return this.preserveSegmentation;
    }

    public void setPreserveSegmentation(boolean preserveSegmentation) {
        this.preserveSegmentation = preserveSegmentation;
    }

    public boolean getReturnRawDocument() {
        return this.returnRawDocument;
    }

    public void setReturnRawDocument(boolean returnRawDocument) {
        this.returnRawDocument = returnRawDocument;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PRESERVESEGMENTATION, "Preserve the segmentation for the next steps", null);
        desc.add(RETURNRAWDOCUMENT, "Return raw documents instead of filter events", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Rainbow Translation Kit Merging", true, false);
        desc.addCheckboxPart(paramDesc.get(PRESERVESEGMENTATION));
        desc.addCheckboxPart(paramDesc.get(RETURNRAWDOCUMENT));
        return desc;
    }
}

