/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.xliff.Candidate;
import net.sf.okapi.lib.xliff.CodeStore;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.InlineType;
import net.sf.okapi.lib.xliff.Note;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.XLIFFWriter;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Options;
import org.oasisopen.xliff.v2.INote;

public class XLIFF2PackageWriter
extends BasePackageWriter {
    private static final Logger LOGGER = Logger.getLogger(XLIFF2PackageWriter.class.getName());
    private XLIFFWriter writer;

    public XLIFF2PackageWriter() {
        super("xliff2");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, false);
        this.setTMXInfo(false, null, null, null, null, false);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        MergingInfo item = this.manifest.getItem(this.docId);
        String path = this.manifest.getSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        XLIFF2Options options = new XLIFF2Options();
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            options.fromString(this.params.getWriterOptions());
        }
        this.writer.setInlineStyle(options.getInlineStyle());
        this.writer.create(new File(path), this.manifest.getSourceLocale().toBCP47());
        this.writer.setLanguages(this.manifest.getSourceLocale().toBCP47(), this.manifest.getTargetLocale().toBCP47());
        this.writer.setIsIndented(true);
        this.writer.writeStartDocument(null, "EXPERIMENTAL OUTPUT ONLY!");
    }

    @Override
    protected void processEndDocument(Event event) {
        this.writer.writeEndDocument();
        this.writer.close();
        this.writer = null;
        super.processEndDocument(event);
    }

    @Override
    protected void processStartSubDocument(Event event) {
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.writeEndFile();
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.writeStartGroup(null);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.writeEndGroup();
    }

    @Override
    protected void processTextUnit(Event event) {
        Unit unit = this.toXLIFF2Unit(event.getTextUnit());
        this.writer.writeUnit(unit);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    private Unit toXLIFF2Unit(ITextUnit tu) {
        Unit unit = new Unit(tu.getId());
        TextContainer srcTc = tu.getSource();
        TextContainer trgTc = null;
        if (tu.hasTarget(this.manifest.getTargetLocale()) && (trgTc = tu.getTarget(this.manifest.getTargetLocale())).getSegments().count() != srcTc.getSegments().count()) {
            LOGGER.warning(String.format("Text unit id='%s' has different number of segments in source and target.\nThis entry will be output un-segmented.", tu.getId()));
            srcTc = tu.getSource().clone();
            srcTc.joinAll();
            trgTc = tu.getTarget(this.manifest.getTargetLocale()).clone();
            trgTc.joinAll();
        }
        if (tu.hasProperty("note")) {
            unit.addNote(new Note(tu.getProperty("note").getValue()));
        }
        if (tu.hasSourceProperty("note")) {
            unit.addNote(new Note(tu.getSourceProperty("note").getValue(), INote.AppliesTo.SOURCE));
        }
        if (tu.hasTargetProperty(this.manifest.getTargetLocale(), "note")) {
            unit.addNote(new Note(tu.getTargetProperty(this.manifest.getTargetLocale(), "note").getValue(), INote.AppliesTo.TARGET));
        }
        ISegments trgSegs = null;
        if (trgTc != null) {
            trgSegs = trgTc.getSegments();
        }
        int srcSegIndex = -1;
        for (int i = 0; i < srcTc.count(); ++i) {
            TextPart part = srcTc.get(i);
            if (part.isSegment()) {
                AltTranslationsAnnotation ann;
                Segment srcSeg = (Segment)part;
                ++srcSegIndex;
                net.sf.okapi.lib.xliff.Segment xSeg = unit.appendNewSegment();
                xSeg.setSource(this.toXLIFF2Fragment(srcSeg.text, unit.getCodeStore(), false));
                xSeg.setId(srcSeg.getId());
                xSeg.setTranslatable(tu.isTranslatable());
                if (trgSegs == null) continue;
                Segment trgSeg = trgSegs.get(xSeg.getId());
                if (trgSeg != null) {
                    xSeg.setTarget(this.toXLIFF2Fragment(trgSeg.text, unit.getCodeStore(), true));
                    int trgSegIndex = trgSegs.getIndex(xSeg.getId());
                    if (srcSegIndex != trgSegIndex) {
                        int trgPartIndex = trgSegs.getPartIndex(trgSegIndex);
                        xSeg.setTargetOrder(trgPartIndex + 1);
                    }
                }
                if ((ann = trgSeg.getAnnotation(AltTranslationsAnnotation.class)) == null) continue;
                for (AltTranslation alt : ann) {
                    this.copyData(alt, srcSeg.text, xSeg);
                }
                continue;
            }
            Part xPart = unit.appendNewIgnorable();
            xPart.setSource(this.toXLIFF2Fragment(part.text, unit.getCodeStore(), false));
            if (trgTc == null) continue;
        }
        return unit;
    }

    private void copyData(AltTranslation alt, TextFragment oriSource, net.sf.okapi.lib.xliff.Segment xSeg) {
        Candidate xAlt = new Candidate();
        CodeStore cs = xAlt.getCodeStore();
        if (alt.getSource().isEmpty()) {
            xAlt.setSource(this.toXLIFF2Fragment(oriSource, cs, false));
        } else {
            xAlt.setSource(this.toXLIFF2Fragment(alt.getSource().getFirstContent(), cs, false));
        }
        xAlt.setTarget(this.toXLIFF2Fragment(alt.getTarget().getFirstContent(), cs, true));
        xSeg.addCandidate(xAlt);
    }

    private Fragment toXLIFF2Fragment(TextFragment tf, CodeStore store, boolean isTarget) {
        if (!tf.hasCode()) {
            return new Fragment(store, isTarget, tf.getCodedText());
        }
        Fragment frag = new Fragment(store, isTarget);
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        for (int i = 0; i < ctext.length(); ++i) {
            if (TextFragment.isMarker(ctext.charAt(i))) {
                int index = TextFragment.toIndex(ctext.charAt(++i));
                Code code = codes.get(index);
                switch (code.getTagType()) {
                    case OPENING: {
                        frag.append(InlineType.OPENING, String.valueOf(code.getId()), code.getData());
                        break;
                    }
                    case CLOSING: {
                        frag.append(InlineType.CLOSING, String.valueOf(code.getId()), code.getData());
                        break;
                    }
                    case PLACEHOLDER: {
                        frag.append(InlineType.PLACEHOLDER, String.valueOf(code.getId()), code.getData());
                    }
                }
                continue;
            }
            frag.append(ctext.charAt(i));
        }
        return frag;
    }
}

