/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.repetitionanalysis;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String FUZZYTHRESHOLD = "fuzzyThreshold";
    private int fuzzyThreshold;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.fuzzyThreshold = 100;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.fuzzyThreshold = this.buffer.getInteger(FUZZYTHRESHOLD, this.fuzzyThreshold);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setInteger(FUZZYTHRESHOLD, this.fuzzyThreshold);
        return this.buffer.toString();
    }

    public void setFuzzyThreshold(int fuzzyThreshold) {
        this.fuzzyThreshold = fuzzyThreshold;
    }

    public int getFuzzyThreshold() {
        return this.fuzzyThreshold;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(FUZZYTHRESHOLD, "Fuzzy threshold (1-100)", "Fuzzy threshold for fuzzy repetitions. Leave 100 for exact repetitions only.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Repetition Analysis");
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(FUZZYTHRESHOLD));
        sip.setRange(1, 100);
        return desc;
    }
}

