/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.textmodification;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.steps.textmodification.Parameters;

@UsingParameters(value=Parameters.class)
public class TextModificationStep
extends BasePipelineStep {
    private static final char STARTSEG = '[';
    private static final char ENDSEG = ']';
    private static final String OLDCHARS = "AaEeIiOoUuYyCcDdNn";
    private static final String NEWCHARS = "\u00c2\u00e5\u00c9\u00e8\u00cf\u00ec\u00d8\u00f5\u00db\u00fc\u00dd\u00ff\u00c7\u00e7\u00d0\u00f0\u00d1\u00f1";
    private Parameters params = new Parameters();
    private LocaleId targetLocale;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getName() {
        return "Text Modification";
    }

    @Override
    public String getDescription() {
        return "Apply various modifications to the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (!this.params.applyToExistingTarget && tu.hasTarget(this.targetLocale)) {
            return event;
        }
        if (!this.params.applyToBlankEntries) {
            TextContainer tc = tu.getTarget(this.targetLocale);
            if (tc == null) {
                tc = tu.getSource();
            }
            if (!tc.hasText()) {
                return event;
            }
        }
        tu.createTarget(this.targetLocale, false, 7);
        if (tu.getTarget(this.targetLocale).isEmpty()) {
            tu.createTarget(this.targetLocale, true, 7);
        }
        switch (this.params.type) {
            case 1: {
                this.replaceWithXN(tu);
                break;
            }
            case 3: {
                this.replaceWithExtendedChars(tu);
                break;
            }
            case 2: {
                this.removeText(tu);
            }
        }
        if (this.params.markSegments) {
            this.addSegmentMarks(tu);
        }
        if (this.params.addPrefix || this.params.addSuffix || this.params.addName || this.params.addID) {
            this.addText(tu);
        }
        return event;
    }

    private void removeText(ITextUnit tu) {
        for (TextPart part : tu.getTarget(this.targetLocale)) {
            StringBuilder sb = new StringBuilder();
            String text = part.text.getCodedText();
            for (int i = 0; i < text.length(); ++i) {
                if (!TextFragment.isMarker(text.charAt(i))) continue;
                sb.append(text.charAt(i));
                sb.append(text.charAt(++i));
            }
            part.text.setCodedText(sb.toString());
        }
    }

    private void replaceWithXN(ITextUnit tu) {
        String tmp = null;
        for (TextPart part : tu.getTarget(this.targetLocale)) {
            tmp = part.text.getCodedText().replaceAll("\\p{Lu}|\\p{Lo}", "X");
            tmp = tmp.replaceAll("\\p{Ll}", "x");
            tmp = tmp.replaceAll("\\d", "N");
            part.text.setCodedText(tmp);
        }
    }

    private void replaceWithExtendedChars(ITextUnit tu) {
        for (TextPart part : tu.getTarget(this.targetLocale)) {
            StringBuilder sb = new StringBuilder(part.text.getCodedText());
            for (int i = 0; i < sb.length(); ++i) {
                if (TextFragment.isMarker(sb.charAt(i))) {
                    ++i;
                    continue;
                }
                int n = OLDCHARS.indexOf(sb.charAt(i));
                if (n <= -1) continue;
                sb.setCharAt(i, NEWCHARS.charAt(n));
            }
            part.text.setCodedText(sb.toString());
        }
    }

    private void addSegmentMarks(ITextUnit tu) {
        for (Segment seg : tu.getTarget(this.targetLocale).getSegments()) {
            seg.text.setCodedText('[' + seg.text.getCodedText() + ']');
        }
    }

    private void addText(ITextUnit tu) {
        TextFragment firstFrag = tu.getTarget(this.targetLocale).getFirstContent();
        TextFragment lastFrag = tu.getTarget(this.targetLocale).getLastContent();
        if (this.params.addPrefix) {
            firstFrag.setCodedText(this.params.prefix + firstFrag.getCodedText());
        }
        if (this.params.addName) {
            String name = tu.getName();
            if (name != null && name.length() > 0) {
                lastFrag.setCodedText(lastFrag.getCodedText() + "_" + name);
            } else {
                lastFrag.setCodedText(lastFrag.getCodedText() + "_" + tu.getId());
            }
        }
        if (this.params.addID) {
            lastFrag.setCodedText(lastFrag.getCodedText() + "_" + tu.getId());
        }
        if (this.params.addSuffix) {
            lastFrag.setCodedText(lastFrag.getCodedText() + this.params.suffix);
        }
    }
}

