/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentDeletes;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class BufferedDeletes {
    private final Map<SegmentInfo, SegmentDeletes> deletesMap = new HashMap<SegmentInfo, SegmentDeletes>();
    private Term lastDeleteTerm;
    private PrintStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final AtomicInteger numTerms = new AtomicInteger();
    private final int messageID;

    public BufferedDeletes(int messageID) {
        this.messageID = messageID;
    }

    private synchronized void message(String message) {
        if (this.infoStream != null) {
            this.infoStream.println("BD " + this.messageID + " [" + new Date() + "; " + Thread.currentThread().getName() + "]: BD " + message);
        }
    }

    public synchronized void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public synchronized void pushDeletes(SegmentDeletes newDeletes, SegmentInfo info) {
        this.pushDeletes(newDeletes, info, false);
    }

    public synchronized void pushDeletes(SegmentDeletes newDeletes, SegmentInfo info, boolean noLimit) {
        assert (newDeletes.any());
        this.numTerms.addAndGet(newDeletes.numTermDeletes.get());
        if (!noLimit) {
            assert (!this.deletesMap.containsKey(info));
            assert (info != null);
            this.deletesMap.put(info, newDeletes);
            this.bytesUsed.addAndGet(newDeletes.bytesUsed.get());
        } else {
            SegmentDeletes deletes = this.getDeletes(info);
            this.bytesUsed.addAndGet(-deletes.bytesUsed.get());
            deletes.update(newDeletes, noLimit);
            this.bytesUsed.addAndGet(deletes.bytesUsed.get());
        }
        if (this.infoStream != null) {
            this.message("push deletes seg=" + info + " dels=" + this.getDeletes(info));
        }
        assert (this.checkDeleteStats());
    }

    public synchronized void clear() {
        this.deletesMap.clear();
        this.numTerms.set(0);
        this.bytesUsed.set(0L);
    }

    synchronized boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    public int numTerms() {
        return this.numTerms.get();
    }

    public long bytesUsed() {
        return this.bytesUsed.get();
    }

    synchronized void commitMerge(MergePolicy.OneMerge merge) {
        SegmentInfo lastInfo;
        SegmentDeletes lastDeletes;
        assert (this.checkDeleteStats());
        if (this.infoStream != null) {
            this.message("commitMerge merge.info=" + merge.info + " merge.segments=" + merge.segments);
        }
        if ((lastDeletes = this.deletesMap.get(lastInfo = (SegmentInfo)merge.segments.lastElement())) != null) {
            this.deletesMap.remove(lastInfo);
            assert (!this.deletesMap.containsKey(merge.info));
            this.deletesMap.put(merge.info, lastDeletes);
            if (this.infoStream != null) {
                this.message("commitMerge done: new deletions=" + lastDeletes);
            }
        } else if (this.infoStream != null) {
            this.message("commitMerge done: no new deletions");
        }
        assert (!this.anyDeletes(merge.segments.range(0, merge.segments.size() - 1)));
        assert (this.checkDeleteStats());
    }

    synchronized void clear(SegmentDeletes deletes) {
        deletes.clear();
    }

    public synchronized boolean applyDeletes(IndexWriter.ReaderPool readerPool, SegmentInfos segmentInfos, SegmentInfos applyInfos) throws IOException {
        if (!this.any()) {
            return false;
        }
        long t0 = System.currentTimeMillis();
        if (this.infoStream != null) {
            this.message("applyDeletes: applyInfos=" + applyInfos + "; index=" + segmentInfos);
        }
        assert (this.checkDeleteStats());
        assert (applyInfos.size() > 0);
        boolean any = false;
        SegmentInfo lastApplyInfo = (SegmentInfo)applyInfos.lastElement();
        int lastIdx = segmentInfos.indexOf(lastApplyInfo);
        SegmentInfo firstInfo = (SegmentInfo)applyInfos.firstElement();
        int firstIdx = segmentInfos.indexOf(firstInfo);
        assert (lastIdx - firstIdx + 1 == applyInfos.size());
        SegmentDeletes coalescedDeletes = null;
        boolean hasDeletes = false;
        for (int segIdx = segmentInfos.size() - 1; segIdx >= firstIdx; --segIdx) {
            SegmentInfo info = segmentInfos.info(segIdx);
            SegmentDeletes deletes = this.deletesMap.get(info);
            assert (deletes == null || deletes.any());
            if (deletes == null && coalescedDeletes == null) continue;
            if (this.infoStream != null) {
                this.message("applyDeletes: seg=" + info + " segment's deletes=[" + (deletes == null ? "null" : deletes) + "]; coalesced deletes=[" + (coalescedDeletes == null ? "null" : coalescedDeletes) + "]");
            }
            if (segIdx <= lastIdx && (hasDeletes |= deletes != null)) {
                long delCountInc = this.applyDeletes(readerPool, info, coalescedDeletes, deletes);
                if (delCountInc != 0L) {
                    any = true;
                }
                if (this.infoStream != null) {
                    this.message("deletes touched " + delCountInc + " docIDs");
                }
                if (deletes != null) {
                    this.bytesUsed.addAndGet(-deletes.docIDs.size() * SegmentDeletes.BYTES_PER_DEL_DOCID);
                    deletes.clearDocIDs();
                }
            }
            if (deletes == null) continue;
            if (coalescedDeletes == null) {
                coalescedDeletes = new SegmentDeletes();
            }
            coalescedDeletes.update(deletes, true);
        }
        if (firstIdx > 0) {
            SegmentDeletes mergedDeletes = null;
            for (SegmentInfo info : applyInfos) {
                SegmentDeletes deletes = this.deletesMap.get(info);
                if (deletes == null) continue;
                assert (deletes.any());
                if (mergedDeletes == null) {
                    mergedDeletes = this.getDeletes(segmentInfos.info(firstIdx - 1));
                    this.numTerms.addAndGet(-mergedDeletes.numTermDeletes.get());
                    assert (this.numTerms.get() >= 0);
                    this.bytesUsed.addAndGet(-mergedDeletes.bytesUsed.get());
                    assert (this.bytesUsed.get() >= 0L);
                }
                mergedDeletes.update(deletes, true);
            }
            if (mergedDeletes != null) {
                this.numTerms.addAndGet(mergedDeletes.numTermDeletes.get());
                this.bytesUsed.addAndGet(mergedDeletes.bytesUsed.get());
            }
            if (this.infoStream != null) {
                if (mergedDeletes != null) {
                    this.message("applyDeletes: merge all deletes into seg=" + segmentInfos.info(firstIdx - 1) + ": " + mergedDeletes);
                } else {
                    this.message("applyDeletes: no deletes to merge");
                }
            }
        }
        this.remove(applyInfos);
        assert (this.checkDeleteStats());
        assert (applyInfos != segmentInfos || !this.any());
        if (this.infoStream != null) {
            this.message("applyDeletes took " + (System.currentTimeMillis() - t0) + " msec");
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long applyDeletes(IndexWriter.ReaderPool readerPool, SegmentInfo info, SegmentDeletes coalescedDeletes, SegmentDeletes segmentDeletes) throws IOException {
        assert (readerPool.infoIsLive(info));
        assert (coalescedDeletes == null || coalescedDeletes.docIDs.size() == 0);
        long delCount = 0L;
        SegmentReader reader = readerPool.get(info, false);
        try {
            if (coalescedDeletes != null) {
                delCount += this.applyDeletes(coalescedDeletes, reader);
            }
            if (segmentDeletes != null) {
                delCount += this.applyDeletes(segmentDeletes, reader);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            readerPool.release(reader);
            throw throwable;
        }
        readerPool.release(reader);
        return delCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long applyDeletes(SegmentDeletes deletes, SegmentReader reader) throws IOException {
        int limit;
        long delCount = 0L;
        assert (this.checkDeleteTerm(null));
        if (deletes.terms.size() > 0) {
            TermDocs docs = reader.termDocs();
            for (Map.Entry<Term, Integer> entry : deletes.terms.entrySet()) {
                int docID;
                Term term = entry.getKey();
                assert (this.checkDeleteTerm(term));
                docs.seek(term);
                limit = entry.getValue();
                while (docs.next() && (docID = docs.doc()) < limit) {
                    ++delCount;
                    reader.deleteDocument(docID);
                }
            }
        }
        for (Integer docIdInt : deletes.docIDs) {
            int n = docIdInt;
            reader.deleteDocument(n);
            ++delCount;
        }
        if (deletes.queries.size() > 0) {
            IndexSearcher searcher = new IndexSearcher(reader);
            try {
                for (Map.Entry<Serializable, Integer> entry : deletes.queries.entrySet()) {
                    int doc;
                    Query query = (Query)entry.getKey();
                    limit = entry.getValue();
                    Weight weight = query.weight(searcher);
                    Scorer scorer = weight.scorer(reader, true, false);
                    if (scorer == null) continue;
                    while ((doc = scorer.nextDoc()) < limit) {
                        reader.deleteDocument(doc);
                        ++delCount;
                    }
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                searcher.close();
                throw throwable;
            }
            searcher.close();
            {
            }
        }
        return delCount;
    }

    public synchronized SegmentDeletes getDeletes(SegmentInfo info) {
        SegmentDeletes deletes = this.deletesMap.get(info);
        if (deletes == null) {
            deletes = new SegmentDeletes();
            this.deletesMap.put(info, deletes);
        }
        return deletes;
    }

    public synchronized void remove(SegmentInfos infos) {
        assert (infos.size() > 0);
        for (SegmentInfo info : infos) {
            SegmentDeletes deletes = this.deletesMap.get(info);
            if (deletes == null) continue;
            this.bytesUsed.addAndGet(-deletes.bytesUsed.get());
            assert (this.bytesUsed.get() >= 0L) : "bytesUsed=" + this.bytesUsed;
            this.numTerms.addAndGet(-deletes.numTermDeletes.get());
            assert (this.numTerms.get() >= 0) : "numTerms=" + this.numTerms;
            this.deletesMap.remove(info);
        }
    }

    private boolean anyDeletes(SegmentInfos infos) {
        for (SegmentInfo info : infos) {
            if (!this.deletesMap.containsKey(info)) continue;
            return true;
        }
        return false;
    }

    private boolean checkDeleteTerm(Term term) {
        if (term != null) assert (this.lastDeleteTerm == null || term.compareTo(this.lastDeleteTerm) > 0) : "lastTerm=" + this.lastDeleteTerm + " vs term=" + term;
        this.lastDeleteTerm = term;
        return true;
    }

    private boolean checkDeleteStats() {
        int numTerms2 = 0;
        long bytesUsed2 = 0L;
        for (SegmentDeletes deletes : this.deletesMap.values()) {
            numTerms2 += deletes.numTermDeletes.get();
            bytesUsed2 += deletes.bytesUsed.get();
        }
        assert (numTerms2 == this.numTerms.get()) : "numTerms2=" + numTerms2 + " vs " + this.numTerms.get();
        assert (bytesUsed2 == this.bytesUsed.get()) : "bytesUsed2=" + bytesUsed2 + " vs " + this.bytesUsed;
        return true;
    }
}

