/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.UnsupportedEncodingException;
import net.sf.okapi.common.Base64;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test {
    @Test
    public void testSimpleConversion() {
        String text = "This is a test.";
        String res = Base64.encodeString(text);
        Assert.assertEquals((Object)text, (Object)Base64.decodeString(res));
    }

    @Test
    public void testExtendedCharacters() {
        String text = "\u00a0\u00c6\u9151\uff3b\uffed\u2605";
        String res = Base64.encodeString(text);
        Assert.assertEquals((Object)text, (Object)Base64.decodeString(res));
    }

    @Test
    public void testMixedCharacters() {
        String text = "\u00a0\u00c6<>&%$#@!Abxz\u9151[]\uff3b\uffed\u2605";
        String res = Base64.encodeString(text);
        Assert.assertEquals((Object)text, (Object)Base64.decodeString(res));
    }

    @Test
    public void testLineBreaks() {
        String text = "\u00a0\n\u00c6\rABC\r\nEnd";
        String res = Base64.encodeString(text);
        Assert.assertEquals((Object)text, (Object)Base64.decodeString(res));
    }

    @Test
    public void testUTF8Bytes() throws UnsupportedEncodingException {
        String text = "\u00a0\u00c6";
        String res = Base64.encodeString(text);
        byte[] expected = text.getBytes("UTF8");
        byte[] output = Base64.decode(res);
        Assert.assertEquals((long)expected.length, (long)output.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)output[i]);
        }
    }

    @Test
    public void testLongBlock() {
        String text = "[This is a long text that may need to be wrapped onto several lines.]";
        String wrapped = "W1RoaXMgaXMg\r\nYSBsb25nIHRleHQgdGhhdC\rBtYXkgb\n\n\nmVlZCB0byBiZSB3cmFwcGVkIG9udG8gc2V\n2ZXJhbCBsaW5lcy5d";
        Assert.assertEquals((Object)text, (Object)Base64.decodeString(wrapped));
    }

    @Test(expected=RuntimeException.class)
    public void testBadInput() {
        Base64.decode("123");
    }
}

