/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.ParametersString;

public abstract class BaseParameters
implements IParameters {
    protected String path = null;
    protected ParametersString buffer = new ParametersString();

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String filePath) {
        this.path = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(URI inputURI, boolean ignoreErrors) {
        try {
            int nCount;
            this.reset();
            URL url = inputURI.toURL();
            InputStreamReader SR = new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), "UTF-8");
            StringBuilder sbTmp = new StringBuilder(1024);
            char[] aBuf = new char[1024];
            while ((nCount = SR.read(aBuf)) > -1) {
                sbTmp.append(aBuf, 0, nCount);
            }
            ((Reader)SR).close();
            SR = null;
            String tmp = sbTmp.toString().replace("\r\n", "\n");
            this.fromString(tmp.replace("\r", "\n"));
            this.path = inputURI.getPath();
        }
        catch (IOException e) {
            if (!ignoreErrors) {
                throw new RuntimeException(e);
            }
        }
        finally {
            Object aBuf = null;
        }
    }

    @Override
    public void save(String newPath) {
        Writer SW = null;
        try {
            SW = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(newPath)), "UTF-8");
            SW.write(this.toString());
            this.path = newPath;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (SW != null) {
                try {
                    SW.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean getBoolean(String name) {
        if (!this.toString().startsWith("#v")) {
            return false;
        }
        return this.buffer.getBoolean(name);
    }

    @Override
    public void setBoolean(String name, boolean value) {
        if (!this.toString().startsWith("#v")) {
            return;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                Method writeMethod = pd.getWriteMethod();
                writeMethod.invoke((Object)this, value);
                this.buffer.setBoolean(name, value);
                return;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Error with setInteger() on '%s':\n" + e.getMessage(), name));
        }
    }

    @Override
    public String getString(String name) {
        if (!this.toString().startsWith("#v")) {
            return null;
        }
        return this.buffer.getString(name);
    }

    @Override
    public void setString(String name, String value) {
        if (!this.toString().startsWith("#v")) {
            return;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                Method writeMethod = pd.getWriteMethod();
                writeMethod.invoke((Object)this, value);
                this.buffer.setString(name, value);
                return;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Error with setInteger() on '%s':\n" + e.getMessage(), name));
        }
    }

    @Override
    public int getInteger(String name) {
        if (!this.toString().startsWith("#v")) {
            return 0;
        }
        return this.buffer.getInteger(name);
    }

    @Override
    public void setInteger(String name, int value) {
        if (!this.toString().startsWith("#v")) {
            return;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                Method writeMethod = pd.getWriteMethod();
                writeMethod.invoke((Object)this, value);
                this.buffer.setInteger(name, value);
                return;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Error with setInteger() on '%s':\n" + e.getMessage(), name));
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        return null;
    }
}

