/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.ClassUtil;
import org.junit.Assert;
import org.junit.Test;

public class ClassUtilTest {
    @Test
    public void testGetPackageName() {
        Assert.assertEquals((Object)"", (Object)ClassUtil.getPackageName(null));
        Assert.assertEquals((Object)"net.sf.okapi.common", (Object)ClassUtil.getPackageName(this.getClass()));
        Assert.assertEquals((Object)"java.lang", (Object)ClassUtil.getPackageName(new String().getClass()));
    }

    @Test
    public void testExtractPackageName() {
        Assert.assertEquals((Object)"", (Object)ClassUtil.extractPackageName(null));
        Assert.assertEquals((Object)"", (Object)ClassUtil.extractPackageName(""));
        Assert.assertEquals((Object)"", (Object)ClassUtil.extractPackageName("aaa/bbb/ccc"));
        Assert.assertEquals((Object)"aaa.bbb", (Object)ClassUtil.extractPackageName("aaa.bbb.ccc"));
        Assert.assertEquals((Object)"net.sf.okapi.common", (Object)ClassUtil.extractPackageName("net.sf.okapi.common.ClassUtil"));
    }

    @Test
    public void testQualifyName() {
        Assert.assertEquals((Object)"", (Object)ClassUtil.qualifyName("", null));
        Assert.assertEquals((Object)"", (Object)ClassUtil.qualifyName("", ""));
        Assert.assertEquals((Object)"", (Object)ClassUtil.qualifyName("package", ""));
        Assert.assertEquals((Object)"", (Object)ClassUtil.qualifyName("", "class"));
        Assert.assertEquals((Object)"package.class", (Object)ClassUtil.qualifyName("package", "class"));
        Assert.assertEquals((Object)"package.class", (Object)ClassUtil.qualifyName("package.", "class"));
        Assert.assertEquals((Object)"package.class", (Object)ClassUtil.qualifyName("package_class", "package.class"));
        Assert.assertEquals((Object)".class", (Object)ClassUtil.qualifyName("package.", ".class"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ClassUtil.qualifyName(new String().getClass(), "Integer"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)ClassUtil.qualifyName(ClassUtil.extractPackageName(new String().getClass().getName()), "Integer"));
        Assert.assertEquals((Object)"net.sf.okapi.common.UtilTest", (Object)ClassUtil.qualifyName(ClassUtil.extractPackageName(this.getClass().getName()), "UtilTest"));
        Assert.assertEquals((Object)"net.sf.okapi.common.UtilTest", (Object)ClassUtil.qualifyName(this, "UtilTest"));
    }

    @Test
    public void testInstantiateClass() {
        String defaultEncoding;
        URL url;
        try {
            ClassUtil.instantiateClass(BOMAwareInputStream.class);
            Assert.fail((String)"InstantiationException should've been trown");
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)"IllegalAccessException shouldn't have been trown");
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass(BOMAwareInputStream.class, (Object[])null));
            Assert.fail((String)"InstantiationException should've been trown");
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)"IllegalAccessException shouldn't have been trown");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        FileInputStream input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNotNull((Object)ClassUtil.instantiateClass(BOMAwareInputStream.class, input, defaultEncoding));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            input = null;
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            Assert.assertNull((Object)ClassUtil.instantiateClass(BOMAwareInputStream.class, input, 3));
            Assert.fail((String)"RuntimeException should've been trown");
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)"IllegalAccessException shouldn't have been trown");
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass((String)null));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass(""));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass("foo.bar"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream"));
            Assert.fail((String)"InstantiationException should've been trown");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNotNull((Object)ClassUtil.instantiateClass("java.lang.String"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.ClassUtilTest2", String.class.getClassLoader()));
            Assert.fail((String)"IllegalArgumentException should've been trown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.ClassUtilTest2", ClassUtil.class.getClassLoader()));
            Assert.fail((String)"InstantiationException should've been trown");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Assert.assertNotNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.ClassUtilTest", this.getClass().getClassLoader()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNotNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", input, defaultEncoding));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            input = null;
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", input, 3));
            Assert.fail((String)"RuntimeException should've been trown");
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNotNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", this.getClass().getClassLoader(), input, defaultEncoding));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", this.getClass().getClassLoader(), input, 10));
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream", String.class.getClassLoader(), input, defaultEncoding));
        }
        catch (RuntimeException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        input = null;
        try {
            url = this.getClass().getResource("/test.txt");
            input = new FileInputStream(new File(url.toURI()));
            defaultEncoding = "UTF-8";
            Assert.assertNull((Object)ClassUtil.instantiateClass("net.sf.okapi.common.BOMAwareInputStream2", this.getClass().getClassLoader(), input, defaultEncoding));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

