/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    private static HashMap<String, Pattern> patternCache = new HashMap();

    public static Pattern getPattern(String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    public static String replaceAll(String string, Pattern pattern, int group, String replacement) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer buf = new StringBuffer();
        int start = 0;
        int end = 0;
        while (matcher.find()) {
            start = matcher.start(group);
            buf.append(string.substring(end, start));
            buf.append(replacement);
            end = matcher.end(group);
        }
        buf.append(string.substring(end));
        return buf.toString();
    }

    public static String replaceAll(String string, String regex, int group, String replacement) {
        return RegexUtil.replaceAll(string, RegexUtil.getPattern(regex), group, replacement);
    }

    public static int countMatches(String string, String regex) {
        return RegexUtil.countMatches(string, regex, 0);
    }

    public static int countMatches(String string, String regex, int matchLen) {
        Pattern pattern = RegexUtil.getPattern(regex);
        Matcher matcher = pattern.matcher(string);
        int count = 0;
        while (matcher.find()) {
            if (matchLen == 0) {
                ++count;
                continue;
            }
            count += string.substring(matcher.start(0), matcher.end(0)).length() / matchLen;
        }
        return count;
    }

    public static int countLeadingQualifiers(String string, String qualifier) {
        return RegexUtil.countMatches(string, qualifier + "+\\b", qualifier.length());
    }

    public static int countTrailingQualifiers(String string, String qualifier) {
        return RegexUtil.countMatches(string, "\\b" + qualifier + "+", qualifier.length());
    }

    public static String escape(String str) {
        str = str.replace("[", "\\[");
        str = str.replace("]", "\\]");
        str = str.replace("\"", "\\\"");
        str = str.replace("^", "\\^");
        str = str.replace("$", "\\$");
        str = str.replace(".", "\\.");
        str = str.replace("|", "\\|");
        str = str.replace("?", "\\?");
        str = str.replace("*", "\\*");
        str = str.replace("+", "\\+");
        str = str.replace("(", "\\(");
        str = str.replace(")", "\\)");
        str = str.replace("{", "\\{");
        str = str.replace("}", "\\}");
        return str;
    }

    public static boolean matches(String st, Pattern pattern) {
        Matcher matcher = pattern.matcher(st);
        return matcher.matches();
    }
}

