/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void testRemoveQualifiers() {
        Assert.assertEquals((Object)"qualified text", (Object)StringUtil.removeQualifiers("\"qualified text\""));
        Assert.assertEquals((Object)"qualified text", (Object)StringUtil.removeQualifiers("\"qualified text\"", "\""));
        Assert.assertEquals((Object)"qualified text", (Object)StringUtil.removeQualifiers("'qualified text'", "'"));
        Assert.assertEquals((Object)"'qualified text'", (Object)StringUtil.removeQualifiers("'qualified text'", "\""));
        Assert.assertEquals((Object)"[qualified text]", (Object)StringUtil.removeQualifiers("((({[qualified text]})))", "((({", "})))"));
        Assert.assertEquals((Object)"qualified text", (Object)StringUtil.removeQualifiers("((({[qualified text]})))", "((({[", "]})))"));
    }

    @Test
    public void testTitleCase() {
        Assert.assertEquals((Object)"Title case", (Object)StringUtil.titleCase("Title case"));
        Assert.assertEquals((Object)"Title case", (Object)StringUtil.titleCase("Title Case"));
        Assert.assertEquals((Object)"Title case", (Object)StringUtil.titleCase("title case"));
        Assert.assertEquals((Object)"Title case", (Object)StringUtil.titleCase("TITLE CASE"));
        Assert.assertEquals((Object)"Title case", (Object)StringUtil.titleCase("tITLE CaSE"));
    }

    @Test
    public void testNormalizeLineBreaks() {
        Assert.assertEquals((Object)"line1\nline2", (Object)StringUtil.normalizeLineBreaks("line1\nline2"));
        Assert.assertEquals((Object)"line1\nline2\n", (Object)StringUtil.normalizeLineBreaks("line1\nline2\n"));
        Assert.assertEquals((Object)"line1\nline2", (Object)StringUtil.normalizeLineBreaks("line1\r\nline2"));
        Assert.assertEquals((Object)"line1\nline2\n", (Object)StringUtil.normalizeLineBreaks("line1\r\nline2\r\n"));
        Assert.assertEquals((Object)"line1\nline2", (Object)StringUtil.normalizeLineBreaks("line1\rline2"));
        Assert.assertEquals((Object)"line1\nline2\n", (Object)StringUtil.normalizeLineBreaks("line1\rline2\r"));
    }

    @Test
    public void testNormalizeWildcards() {
        Assert.assertEquals((Object)"en.*?", (Object)StringUtil.normalizeWildcards("en*"));
        Assert.assertEquals((Object)"en.", (Object)StringUtil.normalizeWildcards("en?"));
        Assert.assertEquals((Object)"en.*?u.*?", (Object)StringUtil.normalizeWildcards("en*u*"));
        Assert.assertEquals((Object)"en.u.", (Object)StringUtil.normalizeWildcards("en?u?"));
        Assert.assertEquals((Object)"en.*?u.", (Object)StringUtil.normalizeWildcards("en*u?"));
        Assert.assertEquals((Object)"en.u.*?", (Object)StringUtil.normalizeWildcards("en?u*"));
        Assert.assertEquals((Object)"([\\d\\w-.]+?", (Object)StringUtil.normalizeWildcards("([\\d\\w-.]+?"));
    }

    @Test
    public void testContainsWildcards() {
        Assert.assertTrue((boolean)StringUtil.containsWildcards("t* has wildcards"));
        Assert.assertTrue((boolean)StringUtil.containsWildcards("t? has wildcards"));
        Assert.assertTrue((boolean)StringUtil.containsWildcards("([\\d\\w-.]+?"));
        Assert.assertFalse((boolean)StringUtil.containsWildcards("no wildcards"));
    }

    @Test
    public void testMatchesWildcard() {
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("filename1.xml", "*.xml"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("filename2.xml", "*.xml"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard(".xml", "*.xml"));
        Assert.assertFalse((boolean)StringUtil.matchesWildcard("filename1.dita", "*.xml"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("filename1.dita", "*.*"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("filename.*", "filename.*"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("filename1.dita", "filename?.d?ta"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("filename5.data", "filename?.d?ta"));
        Assert.assertFalse((boolean)StringUtil.matchesWildcard("filenames5.data", "filename?.d?ta"));
        Assert.assertFalse((boolean)StringUtil.matchesWildcard("word/settings/filenames5.data", "filename?.d?ta"));
        Assert.assertFalse((boolean)StringUtil.matchesWildcard("word/settings/filename5.data", "filename?.d?ta"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("word/settings/filename5.data", "filename?.d?ta", true));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("word/settings/filename5.data", "word/settings/*.*"));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("word/settings/filename5.data", "word/*.*"));
        Assert.assertFalse((boolean)StringUtil.matchesWildcard("word/settings/filename5.data", "word/*.*", true));
        Assert.assertTrue((boolean)StringUtil.matchesWildcard("word/settings/filename5.data", "word/settings/*.*", true));
    }

    @Test
    public void testSplit() {
        String[] chunks = StringUtil.split("item1,   item2,item3,\t\nitem4", ",\\p{Space}*");
        Assert.assertEquals((long)4L, (long)chunks.length);
        Assert.assertEquals((Object)"item1", (Object)chunks[0]);
        Assert.assertEquals((Object)"item2", (Object)chunks[1]);
        Assert.assertEquals((Object)"item3", (Object)chunks[2]);
        Assert.assertEquals((Object)"item4", (Object)chunks[3]);
        chunks = StringUtil.split("item1,   item2 item3\t\nitem4", "[^,\\p{Space}+](\\p{Space}+)", 1);
        Assert.assertEquals((long)3L, (long)chunks.length);
        Assert.assertEquals((Object)"item1,   item2", (Object)chunks[0]);
        Assert.assertEquals((Object)"item3", (Object)chunks[1]);
        Assert.assertEquals((Object)"item4", (Object)chunks[2]);
    }

    @Test
    public void testGetNumOccurrences() {
        Assert.assertEquals((long)3L, (long)StringUtil.getNumOccurrences("1 text 2 text 1 text 1 text 2", "1"));
        Assert.assertEquals((long)2L, (long)StringUtil.getNumOccurrences("1 text 2 text 1 text 1 text 2", "2"));
    }

    @Test
    public void testIsWhitespace() {
        Assert.assertTrue((boolean)StringUtil.isWhitespace("\t   \b\n\f\r"));
        Assert.assertFalse((boolean)StringUtil.isWhitespace("\t  text \b\n\f\r"));
    }

    @Test
    public void testGetString() {
        Assert.assertEquals((Object)"aaaaaaaaaa", (Object)StringUtil.getString(10, 'a'));
        Assert.assertEquals((Object)"\u0001\u0001\u0001", (Object)StringUtil.getString(3, '\u0001'));
        Assert.assertEquals((Object)"", (Object)StringUtil.getString(0, '\u0001'));
        Assert.assertEquals((Object)"", (Object)StringUtil.getString(-3, '\u0001'));
    }

    @Test
    public void testPadString() {
        Assert.assertEquals((Object)"012aaaa7890123456789", (Object)StringUtil.padString("01234567890123456789", 3, 7, 'a'));
        Assert.assertEquals((Object)"aaaaaaa7890123456789", (Object)StringUtil.padString("01234567890123456789", -3, 7, 'a'));
        Assert.assertEquals((Object)"012345678901aaaaaaaa", (Object)StringUtil.padString("01234567890123456789", 12, 70, 'a'));
        Assert.assertEquals((Object)"01234567890123456789", (Object)StringUtil.padString("01234567890123456789", 50, 70, 'a'));
        Assert.assertEquals((Object)"01234567890123456789", (Object)StringUtil.padString("01234567890123456789", -100, -10, 'a'));
    }
}

