/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;

public class ZipFilterWriter
implements IFilterWriter {
    private String outputPath;
    private ZipFile zipOriginal;
    private ZipOutputStream zipOut;
    private byte[] buffer;
    private LocaleId outLoc;
    private String entryName;
    private IFilterWriter subDocWriter;
    private File tempFile;
    private File tempZip;
    private EncoderManager encoderManager;
    private int subDocLevel;

    public ZipFilterWriter(EncoderManager encoderManager) {
        this.encoderManager = encoderManager;
    }

    @Override
    public void cancel() {
        this.zipOriginal = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.zipOriginal = null;
        if (this.zipOut == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.zipOut.close();
            this.zipOut = null;
            if (this.tempZip != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempZip);
                while ((len = orig.read(this.buffer)) > 0) {
                    dest.write(this.buffer, 0, len);
                }
            }
            this.buffer = null;
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new RuntimeException(err);
                }
                if (this.tempZip != null) {
                    this.tempZip.delete();
                    this.tempZip = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "ZipFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.subDocLevel = 0;
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                this.subDocLevel = 0;
                break;
            }
            case START_SUBDOCUMENT: {
                if (this.subDocLevel == 0) {
                    this.processStartSubDocument((StartSubDocument)event.getResource());
                } else {
                    this.subDocWriter.handleEvent(event);
                }
                ++this.subDocLevel;
                break;
            }
            case END_SUBDOCUMENT: {
                --this.subDocLevel;
                if (this.subDocLevel == 0) {
                    this.processEndSubDocument((Ending)event.getResource());
                    break;
                }
                this.subDocWriter.handleEvent(event);
                break;
            }
            case TEXT_UNIT: 
            case START_GROUP: 
            case END_GROUP: {
                this.subDocWriter.handleEvent(event);
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.outLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        throw new UnsupportedOperationException("Method is not supported for this class.");
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void processStartDocument(StartDocument res) {
        try {
            this.buffer = new byte[2048];
            this.zipOriginal = null;
            ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
            if (skel != null) {
                this.zipOriginal = skel.getOriginal();
            }
            this.tempZip = null;
            boolean useTemp = false;
            File f = new File(this.outputPath);
            if (f.exists()) {
                boolean bl = useTemp = !f.delete();
            }
            if (useTemp) {
                this.tempZip = File.createTempFile("zfwTmpZip", null);
                this.zipOut = new ZipOutputStream(new FileOutputStream(this.tempZip.getAbsolutePath()));
            } else {
                Util.createDirectories(this.outputPath);
                this.zipOut = new ZipOutputStream(new FileOutputStream(this.outputPath));
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processDocumentPart(Event event) {
        DocumentPart res = (DocumentPart)event.getResource();
        if (res.getSkeleton() instanceof ZipSkeleton) {
            ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
            ZipFile original = skel.getOriginal();
            if (original == null) {
                original = this.zipOriginal;
            }
            ZipEntry entry = skel.getEntry();
            try {
                int len;
                this.zipOut.putNextEntry(new ZipEntry(entry.getName()));
                InputStream input = original.getInputStream(entry);
                while ((len = input.read(this.buffer)) > 0) {
                    this.zipOut.write(this.buffer, 0, len);
                }
                input.close();
                this.zipOut.closeEntry();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.subDocWriter.handleEvent(event);
        }
    }

    protected ISkeletonWriter createSubDocumentSkeletonWriter(StartSubDocument res) {
        return new GenericSkeletonWriter();
    }

    protected IFilterWriter createSubDocumentFilterWriter(StartSubDocument res) {
        GenericFilterWriter writer = new GenericFilterWriter(this.createSubDocumentSkeletonWriter(res), this.getEncoderManager());
        writer.setOptions(this.outLoc, "UTF-8");
        return writer;
    }

    protected StartDocument convertToStartDocument(StartSubDocument res) {
        StartDocument sd = new StartDocument("sd");
        sd.setLineBreak("\n");
        sd.setSkeleton(res.getSkeleton());
        return sd;
    }

    private void processStartSubDocument(StartSubDocument res) {
        ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
        ZipEntry entry = skel.getEntry();
        if (entry != null) {
            this.entryName = entry.getName();
        }
        try {
            this.tempFile = File.createTempFile("zfwTmp", null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.subDocWriter == null) {
            this.subDocWriter = this.createSubDocumentFilterWriter(res);
        }
        this.subDocWriter.setOutput(this.tempFile.getAbsolutePath());
        StartDocument sd = this.convertToStartDocument(res);
        this.subDocWriter.handleEvent(new Event(EventType.START_DOCUMENT, sd));
    }

    private void processEndSubDocument(Ending res) {
        try {
            int len;
            this.subDocWriter.handleEvent(new Event(EventType.END_DOCUMENT, res));
            this.subDocWriter.close();
            this.subDocWriter = null;
            this.zipOut.putNextEntry(new ZipEntry(this.entryName));
            FileInputStream input = new FileInputStream(this.tempFile);
            while ((len = ((InputStream)input).read(this.buffer)) > 0) {
                this.zipOut.write(this.buffer, 0, len);
            }
            ((InputStream)input).close();
            this.zipOut.closeEntry();
            this.tempFile.delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IFilterWriter getSubDocWriter() {
        return this.subDocWriter;
    }

    public void setSubDocWriter(IFilterWriter subDocWriter) {
        this.subDocWriter = subDocWriter;
        subDocWriter.setOptions(this.outLoc, "UTF-8");
    }
}

