/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.SkeletonUtil;

public class ResourceSimplifier {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean isMultilingual;
    private LocaleId trgLoc;
    private String outEncoding = "UTF-16BE";
    private GenericSkeletonWriter writer = new GenericSkeletonWriter();
    private GenericSkeleton newSkel = new GenericSkeleton();
    private boolean useSDEncoding = true;
    private boolean useSDLocale = true;
    private boolean resolveCodeRefs = true;

    public ResourceSimplifier() {
        StartDocument sd = new StartDocument("");
        sd.setMultilingual(false);
        this.writer.processStartDocument(this.trgLoc, this.outEncoding, null, null, sd);
    }

    public ResourceSimplifier(LocaleId trgLoc) {
        this();
        this.trgLoc = trgLoc;
        this.useSDLocale = false;
    }

    public ResourceSimplifier(LocaleId trgLoc, String outEncoding) {
        this(trgLoc);
        this.outEncoding = outEncoding;
        this.useSDEncoding = false;
    }

    public static MultiEvent packMultiEvent(MultiEvent me) {
        Event prevEvent = null;
        MultiEvent newME = new MultiEvent();
        newME.setId(me.getId());
        for (Event event : me) {
            if (prevEvent != null && event != null && prevEvent.getEventType() == EventType.DOCUMENT_PART && event.getEventType() == EventType.DOCUMENT_PART) {
                IResource prevRes;
                ISkeleton prevSkel;
                IResource res = event.getResource();
                ISkeleton skel = res.getSkeleton();
                if (!(skel instanceof GenericSkeleton) || !((prevSkel = (prevRes = prevEvent.getResource()).getSkeleton()) instanceof GenericSkeleton)) continue;
                ((GenericSkeleton)prevSkel).add((GenericSkeleton)skel);
                continue;
            }
            newME.addEvent(event);
            prevEvent = event;
        }
        return newME;
    }

    public Event convert(Event event) {
        if (event == null) {
            throw new InvalidParameterException("Event cannot be null");
        }
        IResource res = event.getResource();
        if (res instanceof IReferenceable && ((IReferenceable)((Object)res)).isReferent()) {
            this.writer.addToReferents(event);
            return event;
        }
        if (event.getEventType() == EventType.START_DOCUMENT) {
            StartDocument sd = (StartDocument)res;
            this.isMultilingual = sd.isMultilingual();
            if (this.useSDEncoding) {
                this.outEncoding = sd.getEncoding();
            }
            if (this.useSDLocale) {
                this.trgLoc = sd.getLocale();
            }
        }
        if (!this.isComplex(res)) {
            if (event.getEventType() == EventType.END_DOCUMENT) {
                this.writer.close();
            }
            return event;
        }
        MultiEvent me = new MultiEvent();
        this.processResource(res, me);
        switch (event.getEventType()) {
            case END_DOCUMENT: {
                this.writer.close();
            }
            case START_DOCUMENT: 
            case START_SUBDOCUMENT: 
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: {
                res.setSkeleton(null);
                me.addEvent(event, 0);
                break;
            }
            case TEXT_UNIT: 
            case DOCUMENT_PART: {
                break;
            }
            default: {
                return event;
            }
        }
        if (me.size() == 0) {
            return event;
        }
        if (me.size() == 1) {
            return me.iterator().next();
        }
        return new Event(EventType.MULTI_EVENT, this.assignIDs(ResourceSimplifier.packMultiEvent(me), res));
    }

    private MultiEvent assignIDs(MultiEvent me, IResource resource) {
        int counter = 0;
        for (Event event : me) {
            IResource res = event.getResource();
            String resId = resource.getId();
            if (res instanceof DocumentPart && !(resource instanceof DocumentPart)) {
                String id = "";
                id = counter++ == 0 ? resId : String.format("%s_%d", resId, counter++);
                res.setId("" + String.format("dp_%s", id));
                continue;
            }
            res.setId(resId);
        }
        return me;
    }

    private boolean isComplex(IResource res) {
        ISkeleton skel;
        if (res == null) {
            return false;
        }
        if (res instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)res;
            TextFragment tf = tu.getSource().getUnSegmentedContentCopy();
            for (Code code : tf.getCodes()) {
                if (!code.hasReference()) continue;
                return true;
            }
        }
        if ((skel = res.getSkeleton()) == null) {
            return false;
        }
        if (!(skel instanceof GenericSkeleton)) {
            return false;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (SkeletonUtil.isText(part)) continue;
            return true;
        }
        return false;
    }

    private void flushSkeleton(String resId, int dpIndex, MultiEvent me) {
        if (this.newSkel.isEmpty()) {
            return;
        }
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("", false, this.newSkel)));
        this.newSkel = new GenericSkeleton();
    }

    private void addTU(MultiEvent me, String resId, int tuIndex, ITextUnit tu) {
        String id = null;
        if (tuIndex == 1) {
            id = resId;
        } else {
            this.logger.warning("Duplicate TU: " + resId);
            id = String.format("%s_%d", resId, tuIndex);
        }
        ITextUnit newTU = tu.clone();
        newTU.setId(id);
        newTU.setSkeleton(null);
        newTU.setIsReferent(false);
        me.addEvent(new Event(EventType.TEXT_UNIT, newTU));
    }

    private void processResource(IResource resource, MultiEvent me) {
        if (resource == null) {
            throw new InvalidParameterException("Resource parameter cannot be null");
        }
        if (me == null) {
            throw new InvalidParameterException("MultiEvent parameter cannot be null");
        }
        int dpCounter = 0;
        int tuCounter = 0;
        String resId = resource.getId();
        ISkeleton skel = resource.getSkeleton();
        boolean hasGenericSkeleton = skel instanceof GenericSkeleton;
        if (resource instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)resource;
            if (tu.isReferent()) {
                if (!hasGenericSkeleton) {
                    this.newSkel.add(this.writer.getString(tu, this.trgLoc, 1));
                    return;
                }
            } else {
                TextContainer tc = tu.getSource();
                for (TextPart part : tc) {
                    TextFragment tf = part.getContent();
                    for (Code code : tf.getCodes()) {
                        if (!code.hasReference() || !this.resolveCodeRefs) continue;
                        code.setData(this.writer.expandCodeContent(code, this.trgLoc, 0));
                    }
                }
                if (!hasGenericSkeleton) {
                    this.addTU(me, resId, ++tuCounter, tu);
                }
            }
        }
        if (!hasGenericSkeleton) {
            return;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (SkeletonUtil.isText(part)) {
                this.newSkel.add(this.writer.getString(part, 1));
                continue;
            }
            if (SkeletonUtil.isReference(part)) {
                this.flushSkeleton(resId, ++dpCounter, me);
                IReferenceable referent = this.writer.getReference(SkeletonUtil.getRefId(part));
                if (!(referent instanceof IResource)) continue;
                this.processResource((IResource)((Object)referent), me);
                continue;
            }
            if (SkeletonUtil.isSourcePlaceholder(part, resource)) {
                this.processSourcePlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isTargetPlaceholder(part, resource)) {
                this.processTargetPlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isValuePlaceholder(part, resource)) {
                this.newSkel.add(this.writer.getString(part, 1));
                continue;
            }
            if (SkeletonUtil.isExtSourcePlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId);
                this.processSourcePlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isExtTargetPlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId);
                this.processTargetPlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (!SkeletonUtil.isExtValuePlaceholder(part, resource)) continue;
            this.checkExtParent(part.getParent(), resId);
            this.newSkel.add(this.writer.getString(part, 1));
        }
        this.flushSkeleton(resId, ++dpCounter, me);
    }

    private void processSourcePlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (this.isMultilingual) {
            if (part.parent instanceof ITextUnit) {
                this.newSkel.add(this.writer.getContent((ITextUnit)part.parent, null, 0));
            } else {
                this.logger.warning("The self-reference must be a text-unit: " + resId);
                this.newSkel.add(part.parent.toString());
            }
        } else {
            this.flushSkeleton(resId, ++dpCounter, me);
            this.addTU(me, resId, ++tuCounter, (ITextUnit)resource);
        }
    }

    private void processTargetPlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (part.getLocale() == this.trgLoc) {
            this.flushSkeleton(resId, ++dpCounter, me);
            this.addTU(me, resId, ++tuCounter, (ITextUnit)resource);
        } else {
            this.newSkel.add(this.writer.getContent((ITextUnit)resource, part.getLocale(), 1));
        }
    }

    private boolean checkExtParent(IResource parent, String resId) {
        if (parent instanceof IReferenceable) {
            IReferenceable r = (IReferenceable)((Object)parent);
            if (!r.isReferent()) {
                this.logger.warning("Referent flag is not set in parent: " + resId);
                return false;
            }
            return true;
        }
        this.logger.warning("Invalid parent type: " + resId);
        return false;
    }

    public void setResolveCodeRefs(boolean resolve) {
        this.resolveCodeRefs = resolve;
    }

    public boolean getResolveCodeRefs() {
        return this.resolveCodeRefs;
    }
}

