/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.crosslanguage;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    protected static final String SERVERURL = "serverURL";
    protected static final String USER = "user";
    protected static final String APIKEY = "apiKey";
    protected static final String PASSWORD = "password";
    private String serverURL;
    private String user;
    private String apiKey;
    private String password;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.user = this.buffer.getString(USER, this.user);
        this.apiKey = this.buffer.getString(APIKEY, this.apiKey);
        this.serverURL = this.buffer.getString(SERVERURL, this.serverURL);
        this.password = this.buffer.getEncodedString(PASSWORD, this.password);
    }

    @Override
    public void reset() {
        this.user = "myUsername";
        this.apiKey = "myApiKey";
        this.serverURL = "http://gateway.crosslang.com:8080/services/clGateway?wsdl";
        this.password = "";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(USER, this.user);
        this.buffer.setString(APIKEY, this.apiKey);
        this.buffer.setString(SERVERURL, this.serverURL);
        this.buffer.setEncodedString(PASSWORD, this.password);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVERURL, "Server URL", "The full URL of the server (e.g. http://gateway.crosslang.com:8080/services/clGateway?wsdl");
        desc.add(USER, "User name", "The login name to use");
        desc.add(APIKEY, "API key", "The API key for the given user, engine and language pair");
        desc.add(PASSWORD, "Password", "The login passowrd");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("CrossLanguage MT Connector Settings");
        desc.addTextInputPart(paramsDesc.get(SERVERURL));
        desc.addTextInputPart(paramsDesc.get(USER));
        desc.addTextInputPart(paramsDesc.get(APIKEY));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        return desc;
    }
}

