/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Map;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GoogleMTConnector
extends BaseConnector {
    private static final String addressAjax = "http://ajax.googleapis.com/ajax/services/language/translate";
    private static final String baseQueryAjax = "?v=1.0&q=%s&langpair=%s|%s";
    private String hostId;
    private JSONParser parser;
    private QueryUtil util = new QueryUtil();

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Google-MT";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: http://ajax.googleapis.com/ajax/services/language/translate";
    }

    @Override
    public void open() {
        try {
            InetAddress thisIp = InetAddress.getLocalHost();
            this.hostId = "http://" + thisIp.getHostAddress();
            this.parser = new JSONParser();
        }
        catch (UnknownHostException e) {
            this.hostId = "http://unkown";
        }
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment text) {
        this.current = -1;
        return this.queryAjax(text);
    }

    private int queryAjax(TextFragment fragment) {
        try {
            JSONObject object;
            if (!fragment.hasText(false)) {
                return 0;
            }
            String qtext = this.util.toCodedHTML(fragment);
            if (qtext.length() > 5000) {
                return 0;
            }
            URL url = new URL(addressAjax + String.format(baseQueryAjax, URLEncoder.encode(qtext, "UTF-8"), this.srcCode, this.trgCode));
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", this.getClass().getName());
            conn.setRequestProperty("Referer", this.hostId);
            JSONObject map = object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            Map data = (Map)map.get("responseData");
            String res = (String)data.get("translatedText");
            this.result = new QueryResult();
            this.result.weight = this.getWeight();
            this.result.source = fragment;
            this.result.target = fragment.hasCode() ? new TextFragment(this.util.fromCodedHTML(res, fragment, true), fragment.getClonedCodes()) : new TextFragment(this.util.fromCodedHTML(res, fragment, true));
            this.result.setFuzzyScore(95);
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server." + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        if (!code.startsWith("zh") && code.length() > 2) {
            code = code.substring(0, 2);
        }
        return code;
    }
}

