/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class GoogleMTv2Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String APIKEY = "apiKey";
    private String apiKey;

    public GoogleMTv2Parameters() {
        this.reset();
        this.toString();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.apiKey = this.buffer.getEncodedString(APIKEY, this.apiKey);
    }

    @Override
    public void reset() {
        this.apiKey = "";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setEncodedString(APIKEY, this.apiKey);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(APIKEY, "Google API key", "The Google API key to identify the application/user");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Google Translate v2 Connector Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(APIKEY));
        tip.setPassword(true);
        return desc;
    }
}

