/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.pensieve;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.FolderInputPart;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String USESERVER = "useServer";
    private static final String HOST = "host";
    private static final String DBDIRECTORY = "dbDirectory";
    private boolean useServer;
    private String host;
    private String dbDirectory;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    public boolean getUseServer() {
        return this.useServer;
    }

    public void setUseServer(boolean useServer) {
        this.useServer = useServer;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDbDirectory() {
        return this.dbDirectory;
    }

    public void setDbDirectory(String dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.useServer = this.buffer.getBoolean(USESERVER, this.useServer);
        this.host = this.buffer.getString(HOST, this.host);
        this.dbDirectory = this.buffer.getString(DBDIRECTORY, this.dbDirectory);
    }

    @Override
    public void reset() {
        this.dbDirectory = "";
        this.host = "http://localhost:8080/";
        this.useServer = false;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(USESERVER, this.useServer);
        this.buffer.setString(HOST, this.host);
        this.buffer.setString(DBDIRECTORY, this.dbDirectory);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USESERVER, "Use a server (instead of a locale TM)", null);
        desc.add(HOST, "Server URL", "URL of the server to use (e.g. http://localhost:8080/");
        desc.add(DBDIRECTORY, "TM Directory", "Directory of the TM database");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Pensieve TM Connector Settings", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(USESERVER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(HOST));
        tip.setMasterPart(cbp, true);
        FolderInputPart fip = desc.addFolderInputPart(paramsDesc.get(DBDIRECTORY), "TM Directory");
        fip.setMasterPart(cbp, false);
        return desc;
    }
}

