/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.simpletm;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;

public class Parameters
extends BaseParameters {
    static final String DB_EXTENSION = ".h2.db";
    static final String DBPATH = "dbPath";
    static final String PENALIZETARGETWITHDIFFERENTCODES = "penalizeTargetWithDifferentCodes";
    static final String PENALIZESOURCEWITHDIFFERENTCODES = "penalizeSourceWithDifferentCodes";
    private String dbPath;
    private boolean penalizeTargetWithDifferentCodes;
    private boolean penalizeSourceWithDifferentCodes;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.dbPath = this.buffer.getString(DBPATH, this.dbPath);
        this.penalizeTargetWithDifferentCodes = this.buffer.getBoolean(PENALIZETARGETWITHDIFFERENTCODES, this.penalizeTargetWithDifferentCodes);
        this.penalizeSourceWithDifferentCodes = this.buffer.getBoolean(PENALIZESOURCEWITHDIFFERENTCODES, this.penalizeSourceWithDifferentCodes);
    }

    public boolean getPenalizeTargetWithDifferentCodes() {
        return this.penalizeTargetWithDifferentCodes;
    }

    public void setPenalizeTargetWithDifferentCodes(boolean penalizeTargetWithDifferentCodes) {
        this.penalizeTargetWithDifferentCodes = penalizeTargetWithDifferentCodes;
    }

    public boolean getPenalizeSourceWithDifferentCodes() {
        return this.penalizeSourceWithDifferentCodes;
    }

    public void setPenalizeSourceWithDifferentCodes(boolean penalizeSourceWithDifferentCodes) {
        this.penalizeSourceWithDifferentCodes = penalizeSourceWithDifferentCodes;
    }

    @Override
    public void reset() {
        this.dbPath = "";
        this.penalizeTargetWithDifferentCodes = true;
        this.penalizeSourceWithDifferentCodes = true;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(DBPATH, this.dbPath);
        this.buffer.setBoolean(PENALIZETARGETWITHDIFFERENTCODES, this.penalizeTargetWithDifferentCodes);
        this.buffer.setBoolean(PENALIZESOURCEWITHDIFFERENTCODES, this.penalizeSourceWithDifferentCodes);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(DBPATH, "Path of the Database file", String.format("Full path of the database file (%s)", DB_EXTENSION));
        desc.add(PENALIZESOURCEWITHDIFFERENTCODES, "Penalize exact matches when the source has different codes than the query", null);
        desc.add(PENALIZETARGETWITHDIFFERENTCODES, "Penalize exact matches when the target has different codes than the query", null);
        return desc;
    }
}

