/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.translatetoolkit;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String SUPPORTCODES = "supportCodes";
    private String host;
    private int port;
    private boolean supportCodes;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.host = this.buffer.getString(HOST, this.host);
        this.port = this.buffer.getInteger(PORT, this.port);
        this.supportCodes = this.buffer.getBoolean(SUPPORTCODES, this.supportCodes);
    }

    @Override
    public void reset() {
        this.host = "amagama.locamotion.org";
        this.port = 80;
        this.supportCodes = false;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(HOST, this.host);
        this.buffer.setInteger(PORT, this.port);
        this.buffer.setBoolean(SUPPORTCODES, this.supportCodes);
        return this.buffer.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean getSupportCodes() {
        return this.supportCodes;
    }

    public void setSupportCodes(boolean supportCodes) {
        this.supportCodes = supportCodes;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(HOST, "Host", "The host name of the TM server (e.g. localhost)");
        desc.add(PORT, "Port", "The port number of the TM server (e.g. 8080)");
        desc.add(SUPPORTCODES, "Inline codes are letter-coded (e.g. <x1/><g2></g2>)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Translation Toolkit TM Connector Settings");
        desc.addTextInputPart(paramsDesc.get(HOST));
        desc.addTextInputPart(paramsDesc.get(PORT));
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(SUPPORTCODES));
        cbp.setVertical(true);
        return desc;
    }
}

