/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String EXTRACTNOTES = "extractNotes";
    private static final String SIMPLIFYCODES = "simplifyCodes";
    private static final String EXTRACTMASTERSPREADS = "extractMasterSpreads";
    private boolean extractNotes;
    private boolean simplifyCodes;
    private boolean extractMasterSpreads;

    public Parameters() {
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.extractNotes = false;
        this.simplifyCodes = true;
        this.extractMasterSpreads = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.extractNotes = this.buffer.getBoolean(EXTRACTNOTES, this.extractNotes);
        this.simplifyCodes = this.buffer.getBoolean(SIMPLIFYCODES, this.simplifyCodes);
        this.extractMasterSpreads = this.buffer.getBoolean(EXTRACTMASTERSPREADS, this.extractMasterSpreads);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(EXTRACTNOTES, this.extractNotes);
        this.buffer.setBoolean(SIMPLIFYCODES, this.simplifyCodes);
        this.buffer.setBoolean(EXTRACTMASTERSPREADS, this.extractMasterSpreads);
        return this.buffer.toString();
    }

    public boolean getExtractNotes() {
        return this.extractNotes;
    }

    public void setExtractNotes(boolean extractNotes) {
        this.extractNotes = extractNotes;
    }

    public boolean getSimplifyCodes() {
        return this.simplifyCodes;
    }

    public void setSimplifyCodes(boolean simplifyCodes) {
        this.simplifyCodes = simplifyCodes;
    }

    public boolean getExtractMasterSpreads() {
        return this.extractMasterSpreads;
    }

    public void setExtractMasterSpreads(boolean extractMasterSpreads) {
        this.extractMasterSpreads = extractMasterSpreads;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(EXTRACTNOTES, "Extract notes", null);
        desc.add(EXTRACTMASTERSPREADS, "Extract master spreads", null);
        desc.add(SIMPLIFYCODES, "Simplify inline codes when possible", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("IDML Filter", true, false);
        desc.addCheckboxPart(paramsDesc.get(EXTRACTNOTES));
        desc.addCheckboxPart(paramsDesc.get(EXTRACTMASTERSPREADS));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(SIMPLIFYCODES));
        return desc;
    }
}

