/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mosestext;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.IEncoder;

public class MosesTextEncoder
implements IEncoder {
    private static final String LINEBREAK = "<lb/>";

    @Override
    public String encode(String text, int context) {
        if (text == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer(text.length());
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sbTmp.append("&lt;");
                    continue block6;
                }
                case '&': {
                    sbTmp.append("&amp;");
                    continue block6;
                }
                case '\r': {
                    sbTmp.append("&#13;");
                    continue block6;
                }
                case '\n': {
                    sbTmp.append(LINEBREAK);
                    continue block6;
                }
                default: {
                    if (ch > '\u007f') {
                        if (Character.isHighSurrogate(ch)) {
                            int cp = text.codePointAt(i++);
                            String tmp = new String(Character.toChars(cp));
                            sbTmp.append(tmp);
                            continue block6;
                        }
                        sbTmp.append(ch);
                        continue block6;
                    }
                    sbTmp.append(ch);
                }
            }
        }
        return sbTmp.toString();
    }

    @Override
    public String encode(int value, int context) {
        switch (value) {
            case 60: {
                return "&lt;";
            }
            case 38: {
                return "&amp;";
            }
            case 13: {
                return "&#13;";
            }
            case 10: {
                return LINEBREAK;
            }
        }
        if (Character.isSupplementaryCodePoint(value)) {
            return new String(Character.toChars(value)).replace("\n", LINEBREAK);
        }
        return String.valueOf((char)value).replace("\n", LINEBREAK);
    }

    @Override
    public String encode(char value, int context) {
        switch (value) {
            case '<': {
                return "&lt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\r': {
                return "&#13;";
            }
            case '\n': {
                return LINEBREAK;
            }
        }
        return String.valueOf(value);
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return null;
    }

    @Override
    public String getLineBreak() {
        return LINEBREAK;
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }
}

