/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transifex;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.transifex.FilterWriterAnnotation;
import net.sf.okapi.filters.transifex.IProjectEditor;
import net.sf.okapi.filters.transifex.Parameters;
import net.sf.okapi.filters.transifex.Project;
import net.sf.okapi.filters.transifex.TransifexFilterWriter;
import net.sf.okapi.lib.transifex.ResourceInfo;
import net.sf.okapi.lib.transifex.TransifexClient;

@UsingParameters(value=Parameters.class)
public class TransifexFilter
implements IFilter {
    private static final String MIMETYPE = "application/x-transifex";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Parameters params = new Parameters();
    private Project proj = new Project();
    private POFilter pof = new POFilter();
    private Iterator<ResourceInfo> iter;
    private TransifexClient cli;
    private boolean canceled;
    private LinkedList<Event> queue;
    private boolean hasNext;
    private boolean hasMoreDoc;
    private String tempDir;
    private IFilterWriter writer;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        this.pof.close();
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.createFilterWriter().getSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        if (this.writer == null) {
            this.writer = new TransifexFilterWriter();
            this.writer.setOptions(this.proj.getTargetLocale(), null);
        }
        return this.writer;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "Transifex Project", "Transifex project with prompt when starting", null, ".txp;"));
        list.add(new FilterConfiguration(this.getName() + "-noPrompt", MIMETYPE, this.getClass().getName(), "Transifex Project (without prompt)", "Transifex project without prompt when starting", "noPrompt.fprm"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.pof.getEncoderManager();
    }

    @Override
    public String getDisplayName() {
        return "Transifex Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public String getName() {
        return "okf_transifex";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty()) {
                this.nextEventInDocument();
                if (!this.hasMoreDoc) {
                    this.hasNext = false;
                    this.queue.add(Event.NOOP_EVENT);
                }
            }
            return this.queue.poll();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading the package.", e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.close();
            this.canceled = false;
            File temp = File.createTempFile("tx-", null);
            temp.delete();
            temp.mkdirs();
            this.tempDir = temp.getAbsolutePath();
            this.proj.read(new BufferedReader(input.getReader()), input.getSourceLocale(), input.getTargetLocale());
            this.proj.setPath(input.getInputURI().getPath());
            if (this.params.getOpenProject() && !this.editProjectFile()) {
                return;
            }
            this.proj.refreshResources(this.proj.getResources().size() != 0);
            this.cli = new TransifexClient(this.proj.getHost());
            this.cli.setCredentials(this.proj.getUser(), this.proj.getPassword());
            this.cli.setProject(this.proj.getProjectId());
            this.iter = this.proj.getResources().iterator();
            this.hasMoreDoc = true;
            this.queue = new LinkedList();
            this.hasNext = true;
            this.nextDocument();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error processing input.\n" + e.getMessage(), e);
        }
    }

    public boolean editProjectFile() {
        String className = "net.sf.okapi.filters.transifex.ui.ProjectDialog";
        try {
            IProjectEditor dlg = (IProjectEditor)Class.forName(className).newInstance();
            if (!dlg.edit(null, this.proj, true)) {
                this.canceled = true;
                return false;
            }
        }
        catch (Throwable e) {
            this.logger.severe(String.format("Cannot create the editor (%s)\n" + e.getMessage(), className));
            return false;
        }
        return true;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void nextDocument() {
        while (this.iter.hasNext()) {
            ResourceInfo info = this.iter.next();
            if (!info.getSelected() || !this.prepareDocument(info)) continue;
            this.nextEventInDocument();
            return;
        }
        this.hasMoreDoc = false;
    }

    private void nextEventInDocument() {
        if (this.pof.hasNext()) {
            Event e = this.pof.next();
            this.queue.add(e);
        } else {
            this.pof.close();
            this.nextDocument();
        }
    }

    private boolean prepareDocument(ResourceInfo info) {
        this.logger.info("Resource: " + info.getId());
        String outputPath = this.tempDir + File.separator + info.getName();
        String[] res = this.cli.getResource(info.getId(), this.proj.getTargetLocale(), outputPath);
        if (res[0] == null) {
            this.logger.severe(String.format("Could not download the resource '%s'.\n%s", info.getId(), res[1]));
            return false;
        }
        this.pof.getParameters().setBoolean("protectApproved", this.proj.getProtectApproved());
        this.pof.getParameters().setBoolean("allowEmptyOutputTarget", true);
        RawDocument rd = new RawDocument(new File(outputPath).toURI(), "UTF-8", this.proj.getSourceLocale(), this.proj.getTargetLocale());
        this.pof.open(rd);
        if (!this.pof.hasNext()) {
            throw new OkapiBadFilterInputException("Input did not generate an event.");
        }
        Event event = this.pof.next();
        if (event.getEventType() != EventType.START_DOCUMENT) {
            throw new OkapiBadFilterInputException("First event of the input is not a start document event.");
        }
        StartDocument sd = event.getStartDocument();
        FilterWriterAnnotation ann = new FilterWriterAnnotation();
        ann.setData(this.proj, info, sd.getFilterWriter());
        sd.setAnnotation(ann);
        sd.setFilterWriter(this.createFilterWriter());
        this.queue.add(event);
        return true;
    }
}

