/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.versifiedtxt;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.versifiedtxt.Parameters;

@UsingParameters
public class VersifiedTextFilter
extends AbstractFilter {
    private static final Logger LOGGER = Logger.getLogger(VersifiedTextFilter.class.getName());
    private static final int BUFFER_SIZE = 128000;
    public static final String VERSIFIED_TXT_MIME_TYPE = "text/x-versified-txt";
    private static final String VERSE = "^[ \t]*\\|v(.+)[ \t]*$";
    private static final Pattern VERSE_COMPILED = Pattern.compile("^[ \t]*\\|v(.+)[ \t]*$");
    private static final String VERSIFIED_ID = "^([0-9]+)$";
    private static final Pattern VERSIFIED_ID_COMPILED = Pattern.compile("^([0-9]+)$");
    private static final String CHAPTER = "^[ \t]*\\|c.+[ \t]*$";
    private static final String BOOK = "^[ \t]*\\|b.+[ \t]*$";
    private static final String TARGET = "^[ \t]*<TARGET>[ \t]*$";
    private static final String PLACEHOLDER = "(\\{|</?)[0-9]+(\\}|>)";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(\\{|</?)[0-9]+(\\}|>)");
    private String newline = "\n";
    private String currentChapter = "";
    private String currentBook = "";
    private int currentChar;
    private EventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private BufferedReader versifiedFileReader;
    private RawDocument currentRawDocument;
    private BOMNewlineEncodingDetector detector;
    private StartSubDocument startSubDocument;
    private Parameters params;
    private StringBuilder filterBuffer;
    private boolean foundVerse = false;
    private boolean foundBook = false;

    public VersifiedTextFilter() {
        this.setMimeType(VERSIFIED_TXT_MIME_TYPE);
        this.setMultilingual(false);
        this.setFilterWriter(new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager()));
        this.setName("okf_versifiedtxt");
        this.setDisplayName("Versified Text Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), VERSIFIED_TXT_MIME_TYPE, this.getClass().getName(), "Versified Text", "Versified Text Documents"));
        this.setParameters(new Parameters());
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return super.createFilterWriter();
    }

    @Override
    public void open(RawDocument input) {
        this.foundVerse = false;
        this.foundBook = false;
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.currentRawDocument = input;
        this.currentChapter = "";
        this.currentBook = "";
        this.currentChar = -2;
        this.filterBuffer = new StringBuilder(127999);
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setEncoding(input.getEncoding());
        this.hasUtf8Bom = this.detector.hasUtf8Bom();
        this.hasUtf8Encoding = this.detector.hasUtf8Encoding();
        this.newline = this.detector.getNewlineType().toString();
        this.setNewlineType(this.newline);
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            LOGGER.log(Level.FINE, String.format("Overridding user set encoding (if any). Setting auto-detected encoding (%s).", detectedEncoding));
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            LOGGER.log(Level.FINE, String.format("Default encoding and detected encoding not found. Using best guess encoding (%s)", detectedEncoding));
        }
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        this.versifiedFileReader = new BufferedReader(input.getReader());
        String line = "";
        int bufferCount = 0;
        try {
            this.versifiedFileReader.mark(128000);
            while ((line = this.versifiedFileReader.readLine()) != null && (bufferCount += line.length()) < 128000) {
                if (!line.matches(TARGET)) continue;
                this.setMultilingual(true);
                break;
            }
            this.versifiedFileReader.reset();
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error detecting if file is multilingual: " + (line == null ? "unkown line" : line), e);
        }
        if (this.eventBuilder == null) {
            this.eventBuilder = new EventBuilder();
        } else {
            this.eventBuilder.reset(null, this.isSubFilter());
        }
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
        if (this.versifiedFileReader != null) {
            try {
                this.versifiedFileReader.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing the versified text buffered reader.", e);
            }
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(VERSIFIED_TXT_MIME_TYPE, "net.sf.okapi.common.encoder.DefaultEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        String currentLine = null;
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        while (this.currentChar != -1 && !this.isCanceled()) {
            try {
                this.currentChar = this.versifiedFileReader.read();
                this.filterBuffer.append((char)this.currentChar);
                if (this.currentChar != 13 && this.currentChar != 10 && this.currentChar != -1) continue;
                this.filterBuffer.setLength(this.filterBuffer.length() - 1);
                currentLine = this.filterBuffer.toString();
                currentLine = Util.trimEnd(currentLine, "\r\n");
                this.filterBuffer = new StringBuilder(127999);
                if (this.currentChar == -1 && currentLine.isEmpty()) break;
                this.newline = this.handleNewline();
                if (this.currentChar == -1) {
                    this.newline = "";
                }
                if (currentLine.matches(VERSE)) {
                    this.handleDocumentPart(currentLine + this.newline);
                    Matcher m = VERSE_COMPILED.matcher(currentLine);
                    String verseId = "";
                    if (m.matches()) {
                        verseId = m.group(1);
                    }
                    this.handleVerse(this.versifiedFileReader, currentLine, verseId);
                    this.foundVerse = true;
                } else if (currentLine.matches(BOOK)) {
                    this.currentBook = currentLine.substring(2);
                    this.setDocumentName(this.currentBook);
                    this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
                    this.handleDocumentPart(currentLine + this.newline);
                    this.foundBook = true;
                } else if (currentLine.matches(CHAPTER)) {
                    this.currentChapter = currentLine.substring(2);
                    if (this.startSubDocument != null) {
                        this.eventBuilder.endSubDocument();
                    }
                    this.handleSubDocument(this.currentChapter);
                    this.handleDocumentPart(currentLine + this.newline);
                } else {
                    this.handleDocumentPart(currentLine + this.newline);
                }
                if (!this.eventBuilder.hasQueuedEvents()) continue;
                break;
            }
            catch (IOException e) {
                throw new OkapiIOException("IO error reading versified file at: " + (currentLine == null ? "unkown line" : currentLine), e);
            }
        }
        if (this.currentChar == -1) {
            if (this.startSubDocument != null) {
                this.eventBuilder.endSubDocument();
            }
            this.eventBuilder.flushRemainingTempEvents();
            if (!this.foundBook) {
                this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
                LOGGER.warning("Missing book marker at start of document: |b");
            }
            this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
            if (!this.foundVerse) {
                throw new OkapiBadFilterInputException("There are no verse codes in this document");
            }
        }
        return this.eventBuilder.next();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    private String handleNewline() throws IOException {
        String newline = "\n";
        switch (this.detector.getNewlineType()) {
            case CR: {
                newline = "\r";
                break;
            }
            case CRLF: {
                newline = "\r\n";
                this.versifiedFileReader.read();
                break;
            }
            case LF: {
                newline = "\n";
            }
        }
        return newline;
    }

    private void handleSubDocument(String chapter) {
        this.startSubDocument = this.eventBuilder.startSubDocument();
        this.startSubDocument.setName(chapter);
    }

    private void handleVerse(BufferedReader verse, String currentVerse, String verseId) throws IOException {
        String currentLine = null;
        StringBuilder source = new StringBuilder(128000);
        StringBuilder target = new StringBuilder(128000);
        boolean trg = false;
        verse.mark(128000);
        while (this.currentChar != -1) {
            try {
                this.currentChar = this.versifiedFileReader.read();
                this.filterBuffer.append((char)this.currentChar);
                if (this.currentChar != 13 && this.currentChar != 10 && this.currentChar != -1) continue;
                this.filterBuffer.setLength(this.filterBuffer.length() - 1);
                currentLine = this.filterBuffer.toString();
                currentLine = Util.trimEnd(currentLine, "\r\n");
                this.filterBuffer = new StringBuilder(127999);
                this.newline = this.handleNewline();
                if (currentLine.matches(VERSE) || currentLine.matches(BOOK) || currentLine.matches(CHAPTER)) {
                    verse.reset();
                    break;
                }
                if (currentLine.matches(TARGET)) {
                    trg = true;
                    continue;
                }
                if (trg) {
                    target.append(currentLine + "\n");
                } else {
                    source.append(currentLine + "\n");
                }
                verse.mark(128000);
            }
            catch (IOException e) {
                throw new OkapiIOException("IO error reading versified file at: " + (currentLine == null ? "unkown line" : currentLine), e);
            }
        }
        if (this.isMultilingual() && !trg) {
            throw new OkapiBadFilterInputException("Missing <TARGET> tag for verse " + verseId);
        }
        this.eventBuilder.startTextUnit();
        String s = this.chopNewline(source.toString());
        String t = this.chopNewline(target.toString());
        if (this.currentChar != -1) {
            if (trg) {
                s = this.chopNewline(s);
                t = this.chopNewline(t);
            } else {
                s = this.chopNewline(this.chopNewline(s));
            }
        } else if (trg) {
            t = Util.trimEnd(t, "\n");
        } else {
            s = Util.trimEnd(s, "\n");
        }
        this.processPlaceHolders(s, true);
        if (trg) {
            if (this.currentChar == -1 && this.chopNewline(t).isEmpty()) {
                t = "";
            }
            this.processPlaceHolders(t, false);
        }
        this.eventBuilder.setTargetLocale(null);
        ITextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
        GenericSkeleton skel = new GenericSkeleton();
        skel.addContentPlaceholder(tu);
        if (trg) {
            skel.add(this.newline + "<TARGET>" + this.newline);
            skel.addContentPlaceholder(tu, this.getTrgLoc());
        }
        if (this.currentChar != -1) {
            skel.add(this.newline + this.newline);
        }
        tu.setSkeleton(skel);
        Matcher m = VERSIFIED_ID_COMPILED.matcher(verseId);
        if (m.matches()) {
            tu.setName(this.currentBook + ":" + this.currentChapter + ":" + m.group(1));
            tu.setId(this.currentChapter + (this.currentChapter != null && this.currentChapter.isEmpty() ? "" : ":") + m.group(1));
        } else {
            tu.setName(verseId);
            tu.setId(verseId);
        }
        this.eventBuilder.endTextUnit();
    }

    private void processPlaceHolders(String text, boolean source) {
        if (source) {
            this.eventBuilder.setTargetLocale(null);
        } else {
            this.eventBuilder.setTargetLocale(this.getTrgLoc());
        }
        Matcher m = PLACEHOLDER_PATTERN.matcher(text);
        if (m.find()) {
            m.reset();
            String[] chunks = PLACEHOLDER_PATTERN.split(text);
            for (int i = 0; i < chunks.length; ++i) {
                this.eventBuilder.addToTextUnit(chunks[i]);
                if (!m.find()) continue;
                String ph = text.substring(m.start(), m.end());
                this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, ph, ph));
            }
        } else {
            this.eventBuilder.addToTextUnit(text);
        }
    }

    private void handleDocumentPart(String part) {
        this.eventBuilder.addDocumentPart(part);
    }

    private String chopNewline(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (text.charAt(text.length() - 1) == '\n') {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }
}

