/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.xini.XINIWriter;
import net.sf.okapi.filters.xini.jaxb.Element;
import net.sf.okapi.filters.xini.jaxb.Empty;
import net.sf.okapi.filters.xini.jaxb.EndPlaceHolder;
import net.sf.okapi.filters.xini.jaxb.Field;
import net.sf.okapi.filters.xini.jaxb.Page;
import net.sf.okapi.filters.xini.jaxb.PlaceHolder;
import net.sf.okapi.filters.xini.jaxb.Seg;
import net.sf.okapi.filters.xini.jaxb.StartPlaceHolder;
import net.sf.okapi.filters.xini.jaxb.TextContent;
import net.sf.okapi.filters.xini.jaxb.Xini;

public class XINIReader {
    private static final Map<String, String> tagType;
    private static final Logger LOGGER;
    private Xini xini;
    private InputStream xiniStream;

    public void open(RawDocument input) {
        this.xiniStream = input.getStream();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)Xini.class.getPackage().getName());
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement jaxbXini = (JAXBElement)u.unmarshal(this.xiniStream);
            this.xini = (Xini)jaxbXini.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            if (this.xiniStream != null) {
                this.xiniStream.close();
                this.xiniStream = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public LinkedList<Event> getFilterEvents() {
        LinkedList<Event> events = new LinkedList<Event>();
        for (Page page : this.xini.getMain().getPage()) {
            events.addAll(this.processPage(page));
        }
        return events;
    }

    public LinkedList<Event> getFilterEvents(String relDocName) {
        LinkedList<Event> events = new LinkedList<Event>();
        for (Page page : this.xini.getMain().getPage()) {
            if (!page.getPageName().equals(relDocName)) continue;
            events.addAll(this.processPage(page));
            break;
        }
        return events;
    }

    private LinkedList<Event> processPage(Page page) {
        LinkedList<Event> events = new LinkedList<Event>();
        String startDocId = page.getPageID() + "";
        StartDocument startDoc = new StartDocument(startDocId);
        startDoc.setName(page.getPageName());
        startDoc.setFilterWriter(new XINIWriter());
        startDoc.setType("text/x-xini");
        startDoc.setMimeType("text/x-xini");
        startDoc.setMultilingual(false);
        events.add(new Event(EventType.START_DOCUMENT, startDoc));
        for (Element element : page.getElements().getElement()) {
            events.addAll(this.processElement(element));
        }
        Ending ending = new Ending(page.getPageID() + "end");
        events.add(new Event(EventType.END_DOCUMENT, ending));
        return events;
    }

    private LinkedList<Event> processElement(Element element) {
        LinkedList<Event> events = new LinkedList<Event>();
        Element.ElementContent elContent = element.getElementContent();
        if (elContent.getFields() != null) {
            for (Field field : elContent.getFields().getField()) {
                events.addAll(this.processField(field));
            }
        } else if (elContent.getTable() != null || elContent.getINITable() != null) {
            // empty if block
        }
        return events;
    }

    private LinkedList<Event> processField(Field field) {
        LinkedList<Event> events = new LinkedList<Event>();
        TextUnit tu = new TextUnit(field.getExternalID());
        TextContainer tc = new TextContainer();
        String emptySegsFlags = field.getEmptySegmentsFlags();
        if (emptySegsFlags == null) {
            for (Seg xiniSeg : field.getSeg()) {
                TextFragment tf = new TextFragment(this.processSegment(xiniSeg));
                tc.getSegments().append(tf, false);
            }
        } else {
            int nonEmptySegIndex = 0;
            for (int segIndex = 0; segIndex < emptySegsFlags.length(); ++segIndex) {
                char empty = emptySegsFlags.charAt(segIndex);
                if (empty == '0') {
                    Seg xiniSeg = field.getSeg().get(nonEmptySegIndex);
                    ++nonEmptySegIndex;
                    TextFragment tf = new TextFragment(this.processSegment(xiniSeg));
                    boolean collapseIfPreviousEmpty = segIndex == 0;
                    tc.getSegments().append(tf, collapseIfPreviousEmpty);
                    continue;
                }
                tc.getSegments().append(new Segment(""));
            }
        }
        tu.setSource(tc);
        tu.setName(field.getLabel());
        events.add(new Event(EventType.TEXT_UNIT, tu));
        return events;
    }

    private TextFragment processSegment(Seg xiniSeg) {
        return this.serializeTextParts(xiniSeg.getContent());
    }

    private TextFragment serializeTextParts(List<Serializable> parts) {
        TextFragment fragment = new TextFragment();
        for (Serializable part : parts) {
            if (part instanceof String) {
                fragment.append((String)((Object)part));
                continue;
            }
            if (!(part instanceof JAXBElement)) continue;
            fragment.append(this.processInlineTag(part));
        }
        return fragment;
    }

    private TextFragment processInlineTag(Serializable part) {
        TextFragment fragment = new TextFragment();
        JAXBElement jaxbEl = (JAXBElement)part;
        List<Serializable> content = null;
        if (jaxbEl.getValue() instanceof PlaceHolder) {
            JAXBElement ph = (JAXBElement)part;
            content = ((PlaceHolder)ph.getValue()).getContent();
            if (content == null || content.isEmpty()) {
                Code code = new Code(TextFragment.TagType.PLACEHOLDER, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                fragment.append(code);
            } else {
                Code code = new Code(TextFragment.TagType.OPENING, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                fragment.append(code);
                TextFragment innerText = this.serializeTextParts(content);
                fragment.append(innerText);
                code = new Code(TextFragment.TagType.CLOSING, null);
                code.setId(((PlaceHolder)ph.getValue()).getID());
                fragment.append(code);
            }
        } else if (jaxbEl.getValue() instanceof StartPlaceHolder) {
            JAXBElement sph = (JAXBElement)part;
            Code code = new Code(TextFragment.TagType.OPENING, null);
            code.setId(((StartPlaceHolder)sph.getValue()).getID());
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof EndPlaceHolder) {
            JAXBElement eph = (JAXBElement)part;
            Code code = new Code(TextFragment.TagType.CLOSING, null);
            code.setId(((EndPlaceHolder)eph.getValue()).getID());
            fragment.append(code);
        } else if (jaxbEl.getValue() instanceof Empty) {
            LOGGER.warning("Inline element " + jaxbEl.getName() + "will be ignored");
        } else if (jaxbEl.getValue() instanceof TextContent) {
            LOGGER.warning("Inline element " + jaxbEl.getName() + "will be ignored");
            JAXBElement txtC = (JAXBElement)part;
            TextFragment innerText = this.serializeTextParts(((TextContent)txtC.getValue()).getContent());
            fragment.append(innerText);
        } else {
            throw new RuntimeException("Unknown inline element: " + part);
        }
        return fragment;
    }

    static {
        LOGGER = Logger.getLogger(XINIReader.class.getName());
        HashMap<String, String> tagTypes = new HashMap<String, String>();
        tagTypes.put("b", "bold");
        tagTypes.put("i", "italic");
        tagTypes.put("u", "underlined");
        tagTypes.put("sup", "superscript");
        tagTypes.put("sub", "subscript");
        tagTypes.put("br", "lb");
        tagType = Collections.unmodifiableMap(tagTypes);
    }
}

