/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.beans.v1.PropertyBean;
import net.sf.okapi.lib.beans.v1.TextContainerBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class TextUnitBean
extends PersistenceBean<ITextUnit> {
    private String id;
    private int refCount;
    private String name;
    private String type;
    private boolean isTranslatable;
    private boolean preserveWS;
    private FactoryBean skeleton = new FactoryBean();
    private List<PropertyBean> properties = new ArrayList<PropertyBean>();
    private AnnotationsBean annotations = new AnnotationsBean();
    private TextContainerBean source = new TextContainerBean();
    private String mimeType;
    private Map<String, TextContainerBean> targets = new ConcurrentHashMap<String, TextContainerBean>();

    @Override
    protected ITextUnit createObject(IPersistenceSession session) {
        return new TextUnit(this.getId());
    }

    @Override
    protected void fromObject(ITextUnit obj, IPersistenceSession session) {
        this.id = obj.getId();
        this.refCount = obj.getReferenceCount();
        this.name = obj.getName();
        this.type = obj.getType();
        this.isTranslatable = obj.isTranslatable();
        this.preserveWS = obj.preserveWhitespaces();
        this.skeleton.set(obj.getSkeleton(), session);
        for (String propName : obj.getPropertyNames()) {
            PropertyBean propBean = new PropertyBean();
            propBean.set(obj.getProperty(propName), session);
            this.properties.add(propBean);
        }
        this.annotations.set(obj.getAnnotations(), session);
        this.source.set(obj.getSource(), session);
        this.mimeType = obj.getMimeType();
        for (LocaleId locId : obj.getTargetLocales()) {
            TextContainerBean targetBean = new TextContainerBean();
            this.targets.put(locId.toString(), targetBean);
            targetBean.set(obj.getTarget(locId), session);
        }
    }

    @Override
    protected void setObject(ITextUnit obj, IPersistenceSession session) {
        obj.setId(this.id);
        obj.setReferenceCount(this.refCount);
        obj.setName(this.name);
        obj.setType(this.type);
        obj.setIsTranslatable(this.isTranslatable);
        obj.setPreserveWhitespaces(this.preserveWS);
        obj.setSkeleton(this.skeleton.get(ISkeleton.class, session));
        for (PropertyBean propBean : this.properties) {
            obj.setProperty(propBean.get(Property.class, session));
        }
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
        obj.setSource(this.source.get(TextContainer.class, session));
        obj.setMimeType(this.mimeType);
        for (String locTag : this.targets.keySet()) {
            obj.setTarget(new LocaleId(locTag), this.targets.get(locTag).get(TextContainer.class, session));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    public void setTranslatable(boolean isTranslatable) {
        this.isTranslatable = isTranslatable;
    }

    public boolean isPreserveWS() {
        return this.preserveWS;
    }

    public void setPreserveWS(boolean preserveWS) {
        this.preserveWS = preserveWS;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public TextContainerBean getSource() {
        return this.source;
    }

    public void setSource(TextContainerBean source) {
        this.source = source;
    }

    public void setSkeleton(FactoryBean skeleton) {
        this.skeleton = skeleton;
    }

    public FactoryBean getSkeleton() {
        return this.skeleton;
    }

    public Map<String, TextContainerBean> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, TextContainerBean> targets) {
        this.targets = targets;
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }

    public List<PropertyBean> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyBean> properties) {
        this.properties = properties;
    }

    public void setRefCount(int refCount) {
        this.refCount = refCount;
    }

    public int getRefCount() {
        return this.refCount;
    }
}

