/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.lib.beans.v1.GenericSkeletonBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class ZipSkeletonBean
extends GenericSkeletonBean {
    private FactoryBean original = new FactoryBean();
    private String entry;

    @Override
    protected GenericSkeleton createObject(IPersistenceSession session) {
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        zipFile = this.original.get(ZipFile.class, session);
        if (zipFile != null && !Util.isEmpty(this.entry)) {
            zipEntry = zipFile.getEntry(this.entry);
        }
        return new ZipSkeleton(super.createObject(session), zipFile, zipEntry);
    }

    @Override
    protected void fromObject(GenericSkeleton obj, IPersistenceSession session) {
        super.fromObject(obj, session);
        if (obj instanceof ZipSkeleton) {
            ZipSkeleton zs = (ZipSkeleton)obj;
            this.original.set(zs.getOriginal(), session);
            ZipEntry ze = zs.getEntry();
            if (ze != null) {
                this.entry = ze.getName();
            }
        }
    }

    @Override
    protected void setObject(GenericSkeleton obj, IPersistenceSession session) {
        super.setObject(obj, session);
    }

    public FactoryBean getOriginal() {
        return this.original;
    }

    public void setOriginal(FactoryBean original) {
        this.original = original;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }
}

