/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.connectors.google.GoogleMTConnector;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.IssueType;
import net.sf.okapi.lib.verification.QualityChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LanguageToolConnector {
    private ArrayList<Issue> issues = new ArrayList();
    private String lang;
    private String serverUrl;
    private DocumentBuilder docBuilder;
    private IQuery mt;
    private boolean bilingualMode;

    public LanguageToolConnector() {
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        try {
            this.docBuilder = Fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating document builder.", e);
        }
    }

    public void initialize(LocaleId locId, String serverUrl, boolean translateLTMsg, boolean bilingualMode, String ltTranslationSource, String ltTranslationTarget) {
        this.lang = locId.getLanguage();
        if (!serverUrl.endsWith("/")) {
            serverUrl = serverUrl + "/";
        }
        this.serverUrl = serverUrl;
        if (this.mt != null) {
            this.mt.close();
            this.mt = null;
        }
        this.bilingualMode = bilingualMode;
        if (translateLTMsg) {
            this.mt = new GoogleMTConnector();
            this.mt.setLanguages(LocaleId.fromBCP47(ltTranslationSource), LocaleId.fromBCP47(ltTranslationTarget));
            this.mt.open();
        }
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public int checkSegment(URI docId, Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        this.issues.clear();
        if (!trgSeg.text.hasText()) {
            return 0;
        }
        String ctext = trgSeg.text.getCodedText();
        try {
            URL url = this.bilingualMode ? new URL(this.serverUrl + String.format("?language=%s&text=%s&srctext=%s", this.lang, URLEncoder.encode(ctext, "UTF-8"), URLEncoder.encode(srcSeg.text.getCodedText(), "UTF-8"))) : new URL(this.serverUrl + String.format("?language=%s&text=%s", this.lang, URLEncoder.encode(ctext, "UTF-8")));
            URLConnection conn = url.openConnection();
            Document doc = this.docBuilder.parse(conn.getInputStream(), "UTF-8");
            NodeList errors = doc.getDocumentElement().getElementsByTagName("error");
            for (int i = 0; i < errors.getLength(); ++i) {
                Element error = (Element)errors.item(i);
                String msg = error.getAttribute("msg");
                if (this.mt != null && this.mt.query(msg) > 0) {
                    msg = String.format("%s  (--> %s)", msg, this.mt.next().target.toText());
                }
                int start = Integer.valueOf(error.getAttribute("fromx"));
                int end = start + Integer.valueOf(error.getAttribute("errorlength"));
                this.issues.add(new Issue(docId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), msg, 0, 0, QualityChecker.fromFragmentToString(trgSeg.text, start), QualityChecker.fromFragmentToString(trgSeg.text, end), 1, tu.getName()));
            }
        }
        catch (Throwable e) {
            this.issues.add(new Issue(docId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), "Error with LanguageTool server. All LT checks are skipped from this text unit on. " + e.getMessage(), 0, -99, 0, -1, 2, tu.getName()));
        }
        return this.issues.size();
    }
}

