/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.ICode;
import org.oasisopen.xliff.v2.ICodes;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.InlineType;

public class Codes
implements ICodes {
    private static final long serialVersionUID = 64L;
    private IDataStore store;
    private ArrayList<ICode> codes;

    public Codes(IDataStore store) {
        this.store = store;
    }

    @Override
    public boolean hasCode() {
        return this.codes != null && !this.codes.isEmpty();
    }

    @Override
    public boolean hasCodeWithOriginalData() {
        if (this.codes != null) {
            for (ICode code : this.codes) {
                if (!code.hasOriginalData()) continue;
                return true;
            }
        }
        return false;
    }

    public ICode getClosingPart(ICode openingCode) {
        for (ICode code : this.codes) {
            if (!code.getId().equals(openingCode.getId())) continue;
            return code;
        }
        return null;
    }

    public ICode getOpeningPart(ICode closingCode) {
        for (ICode code : this.codes) {
            if (!code.getId().equals(closingCode.getId())) continue;
            return code;
        }
        return null;
    }

    @Override
    public int size() {
        if (this.codes == null) {
            return 0;
        }
        return this.codes.size();
    }

    @Override
    public IDataStore getDataStore() {
        return this.store;
    }

    @Override
    public ICode get(int index) {
        if (this.codes == null) {
            return null;
        }
        return this.codes.get(index);
    }

    @Override
    public ICode get(String id, InlineType type) {
        if (this.codes == null) {
            return null;
        }
        String tmp = Util.toInternalId(id, type);
        for (ICode code : this.codes) {
            if (!code.getInternalId().equals(tmp)) continue;
            return code;
        }
        return null;
    }

    @Override
    public void add(ICode code) {
        if (this.codes == null) {
            this.codes = new ArrayList();
        }
        this.codes.add(code);
    }

    boolean validateClosingTypesMatchOpeningTypes() {
        if (this.codes == null) {
            return true;
        }
        for (ICode code : this.codes) {
            ICode opening;
            if (!code.getInlineType().equals((Object)InlineType.CLOSING) || (opening = this.getOpeningPart(code)) == null) continue;
            String oType = opening.getType();
            String cType = code.getType();
            if (oType == null && cType == null) continue;
        }
        return true;
    }
}

