/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.okapi.lib.xliff.Code;
import net.sf.okapi.lib.xliff.Codes;
import net.sf.okapi.lib.xliff.DataStore;
import net.sf.okapi.lib.xliff.Util;
import org.oasisopen.xliff.v2.ICode;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.InlineType;

public class Fragment
implements IFragment {
    private static final long serialVersionUID = 64L;
    public static final char CODE_OPENING = '\ue101';
    public static final char CODE_CLOSING = '\ue102';
    public static final char CODE_PLACEHOLDER = '\ue103';
    public static final char ANNO_OPENING = '\ue104';
    public static final char ANNO_CLOSING = '\ue105';
    public static final char ANNO_PLACEHOLDER = '\ue106';
    public static final int INDEX_BASE = 57616;
    public static final int INDEX_MAX = 6127;
    private StringBuilder ctext;
    private Codes codes;

    public static char toChar(int index) {
        if (index > 6127) {
            throw new RuntimeException(String.format("This implementation cannot have fragments with more than %d inline codes.", 6127));
        }
        return (char)(index + 57616);
    }

    public static int toIndex(char index) {
        return index - 57616;
    }

    public static boolean isMarker(char ch) {
        return ch == '\ue103' || ch == '\ue101' || ch == '\ue102' || ch == '\ue106' || ch == '\ue104' || ch == '\ue105';
    }

    public Fragment(DataStore store) {
        this.ctext = new StringBuilder();
        if (store != null) {
            this.codes = store.getSourceCodes();
        }
    }

    public Fragment(DataStore store, boolean target) {
        this.ctext = new StringBuilder();
        if (store != null) {
            this.codes = target ? store.getTargetCodes() : store.getSourceCodes();
        }
    }

    public Fragment(DataStore store, boolean target, String plainText) {
        this.ctext = new StringBuilder(plainText);
        if (store != null) {
            this.codes = target ? store.getTargetCodes() : store.getSourceCodes();
        }
    }

    @Override
    public String toString() {
        return this.ctext.toString();
    }

    @Override
    public String getCodedText() {
        return this.ctext.toString();
    }

    @Override
    public String toXLIFF(int style) {
        switch (style) {
            case 1: {
                return this.toXLIFFWithOriginalData(true);
            }
            case 2: {
                return this.toXLIFFWithOriginalData(false);
            }
        }
        return this.toXLIFF();
    }

    @Override
    public IDataStore getDataStore() {
        return this.codes.getDataStore();
    }

    private String toXLIFFWithOriginalData(boolean dataInside) {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> verified = new ArrayList<String>();
        block6: for (int i = 0; i < this.ctext.length(); ++i) {
            ICode code;
            int cp = this.ctext.codePointAt(i);
            if (cp == 57601) {
                code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i)));
                ICode closing = null;
                if (!dataInside) {
                    closing = this.getWellFormedClosing(code, i);
                }
                if (closing != null) {
                    tmp.append(String.format("<pc id=\"%s\"", code.getId()));
                    verified.add(code.getId());
                } else {
                    tmp.append(String.format("<sc id=\"%s\"", code.getId()));
                }
                this.printCommonAttributes(code, tmp, closing, true);
                if (dataInside) {
                    if (Util.isNullOrEmpty(code.getOriginalData())) {
                        tmp.append("/>");
                        continue;
                    }
                    tmp.append(">" + Util.toSafeXML(code.getOriginalData()) + "</sc>");
                    continue;
                }
                if (code.hasOriginalData()) {
                    String ending = closing == null ? "" : "Start";
                    tmp.append(String.format(" nid%s=\"%s\"", ending, this.codes.getDataStore().getIdForOriginalData(code.getOriginalData())));
                }
                tmp.append(closing == null ? "/>" : ">");
                continue;
            }
            if (cp == 57602) {
                if (verified.contains((code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId())) {
                    tmp.append("</pc>");
                    continue;
                }
                tmp.append(String.format("<ec rid=\"%s\"", code.getId()));
                this.printCommonAttributes(code, tmp, null, false);
                if (dataInside) {
                    if (Util.isNullOrEmpty(code.getOriginalData())) {
                        tmp.append("/>");
                        continue;
                    }
                    tmp.append(">" + Util.toSafeXML(code.getOriginalData()) + "</ec>");
                    continue;
                }
                if (code.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.codes.getDataStore().getIdForOriginalData(code.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            if (cp == 57603) {
                int index = Fragment.toIndex(this.ctext.charAt(++i));
                code = this.codes.get(index);
                tmp.append(String.format("<ph id=\"%s\"", code.getId()));
                this.printCommonAttributes(code, tmp, null, false);
                if (dataInside) {
                    if (Util.isNullOrEmpty(code.getOriginalData())) {
                        tmp.append("/>");
                        continue;
                    }
                    tmp.append(">" + Util.toSafeXML(code.getOriginalData()) + "</ph>");
                    continue;
                }
                if (code.hasOriginalData()) {
                    tmp.append(String.format(" nid=\"%s\"", this.codes.getDataStore().getIdForOriginalData(code.getOriginalData())));
                }
                tmp.append("/>");
                continue;
            }
            switch (cp) {
                case 13: {
                    tmp.append("&#13;");
                    continue block6;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block6;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block6;
                }
                case 9: 
                case 10: {
                    tmp.append((char)cp);
                    continue block6;
                }
                default: {
                    if (cp < 32 || cp > 55295 && cp < 57344 || cp == 65535) {
                        tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                        continue block6;
                    }
                    if (cp < 65535) {
                        tmp.append((char)cp);
                        continue block6;
                    }
                    if (cp <= 65535) continue block6;
                    tmp.append(Character.toChars(cp));
                    ++i;
                }
            }
        }
        return tmp.toString();
    }

    private void printCommonAttributes(ICode code, StringBuilder tmp, ICode closing, boolean outputNid) {
        String ending;
        if (code.getType() != null) {
            tmp.append(String.format(" type=\"%s\"", code.getType()));
        }
        String string = ending = closing == null ? "" : "Start";
        if (code.getEquiv() != null) {
            tmp.append(String.format(" equiv%s=\"%s\"", ending, code.getEquiv()));
        }
        if (code.getDisp() != null) {
            tmp.append(String.format(" disp%s=\"%s\"", ending, code.getDisp()));
        }
        if (code.getSubFlows() != null) {
            tmp.append(String.format(" subFlows%s=\"%s\"", ending, code.getSubFlows()));
        }
        if (closing != null) {
            if (closing.getEquiv() != null) {
                tmp.append(String.format(" equivEnd=\"%s\"", closing.getEquiv()));
            }
            if (closing.getDisp() != null) {
                tmp.append(String.format(" dispEnd=\"%s\"", closing.getDisp()));
            }
            if (closing.getSubFlows() != null) {
                tmp.append(String.format(" subFlowsEnd=\"%s\"", closing.getSubFlows()));
            }
            if (outputNid && closing.hasOriginalData()) {
                tmp.append(String.format(" nidEnd=\"%s\"", this.codes.getDataStore().getIdForOriginalData(closing.getOriginalData())));
            }
        }
    }

    @Override
    public String toXLIFF() {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> verified = new ArrayList<String>();
        block6: for (int i = 0; i < this.ctext.length(); ++i) {
            ICode code;
            int cp = this.ctext.codePointAt(i);
            if (cp == 57601) {
                ICode closing;
                if ((closing = this.getWellFormedClosing(code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i))), i)) != null) {
                    tmp.append(String.format("<pc id=\"%s\"", code.getId()));
                    this.printCommonAttributes(code, tmp, closing, false);
                    verified.add(code.getId());
                    tmp.append(">");
                    continue;
                }
                tmp.append(String.format("<sc id=\"%s\"", code.getId()));
                this.printCommonAttributes(code, tmp, null, false);
                tmp.append("/>");
                continue;
            }
            if (cp == 57602) {
                if (verified.contains((code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId())) {
                    tmp.append("</pc>");
                    continue;
                }
                tmp.append(String.format("<ec rid=\"%s\"", code.getId()));
                this.printCommonAttributes(code, tmp, null, false);
                tmp.append("/>");
                continue;
            }
            if (cp == 57603) {
                code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i)));
                tmp.append(String.format("<ph id=\"%s\"", code.getId()));
                this.printCommonAttributes(code, tmp, null, false);
                tmp.append("/>");
                continue;
            }
            switch (cp) {
                case 13: {
                    tmp.append("&#13;");
                    continue block6;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block6;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block6;
                }
                case 9: 
                case 10: {
                    tmp.append((char)cp);
                    continue block6;
                }
                default: {
                    if (cp < 32 || cp > 55295 && cp < 57344 || cp == 65535) {
                        tmp.append(String.format("<cp hex=\"%04X\"/>", cp));
                        continue block6;
                    }
                    if (cp < 65535) {
                        tmp.append((char)cp);
                        continue block6;
                    }
                    if (cp <= 65535) continue block6;
                    tmp.append(Character.toChars(cp));
                    ++i;
                }
            }
        }
        return tmp.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.ctext.length() == 0;
    }

    @Override
    public ICode getWellFormedClosing(ICode openingCode, int from) {
        Stack<String> stack = new Stack<String>();
        for (int i = from; i < this.ctext.length(); ++i) {
            ICode code;
            char ch = this.ctext.charAt(i);
            if (ch == '\ue101') {
                code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i)));
                stack.push(code.getId());
                continue;
            }
            if (ch == '\ue102') {
                if ((code = this.codes.get(Fragment.toIndex(this.ctext.charAt(++i)))).getId().equals(openingCode.getId())) {
                    if (stack.isEmpty()) {
                        return code;
                    }
                    return null;
                }
                if (stack.isEmpty()) {
                    return null;
                }
                if (((String)stack.pop()).equals(code.getId())) continue;
                return null;
            }
            if (ch != '\ue103') continue;
            ++i;
        }
        return null;
    }

    @Override
    public void append(String plainText) {
        this.ctext.append(plainText);
    }

    @Override
    public void append(char ch) {
        this.ctext.append(ch);
    }

    @Override
    public ICode append(ICode code) {
        this.codes.add(code);
        switch (code.getInlineType()) {
            case OPENING: {
                this.ctext.append("\ue101" + Fragment.toChar(this.codes.size() - 1));
                break;
            }
            case CLOSING: {
                this.ctext.append("\ue102" + Fragment.toChar(this.codes.size() - 1));
                break;
            }
            case PLACEHOLDER: {
                this.ctext.append("\ue103" + Fragment.toChar(this.codes.size() - 1));
            }
        }
        return code;
    }

    @Override
    public ICode append(InlineType type, String id, String originalData) {
        if (this.codes == null) {
            throw new RuntimeException("Cannot add codes in this fragment because it has no associated store of codes.");
        }
        Code code = new Code(type, id, originalData);
        return this.append(code);
    }
}

