/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff;

import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.lib.xliff.GroupData;
import net.sf.okapi.lib.xliff.Part;
import net.sf.okapi.lib.xliff.SectionData;
import net.sf.okapi.lib.xliff.Segment;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.XLIFFEvent;
import net.sf.okapi.lib.xliff.XLIFFReader;
import net.sf.okapi.lib.xliff.XLIFFWriter;

public class Main {
    private int style = 1;
    private boolean verbose = false;

    public static void main(String[] args) {
        Main main = new Main();
        System.out.println("============================================================");
        System.out.println("XLIFF 2.0 Read/Write Test Tool");
        boolean showUsage = false;
        int outputStyle = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (String arg : args) {
            String opt = arg.toLowerCase();
            if (opt.equals("-verbose")) {
                main.setVerbose(true);
                continue;
            }
            if (opt.equals("-inside")) {
                outputStyle = 1;
                continue;
            }
            if (opt.equals("-outside")) {
                outputStyle = 2;
                continue;
            }
            if (arg.equals("-?") || opt.equals("-h")) {
                showUsage = true;
                continue;
            }
            if (arg.startsWith("-")) {
                System.out.println("Invalid option: " + arg);
                showUsage = true;
                continue;
            }
            list.add(new File(arg));
        }
        if (showUsage || list.isEmpty()) {
            System.out.println("------------------------------------------------------------");
            System.out.println("Parameters: [options] file1 file2 ...");
            System.out.println("Where options are:");
            System.out.println("-verbose: show the details of the documents being read");
            System.out.println("-outside: in the output, store original data of codes outside the content");
            System.out.println("-inside:  in the output, store original data of codes inside the content");
            System.out.println("-? or -h = shows this help");
            return;
        }
        XLIFFReader reader = new XLIFFReader();
        for (File input : list) {
            String path = input.getAbsolutePath();
            String ext = "";
            int n = path.lastIndexOf(46);
            if (n > -1) {
                ext = path.substring(n);
                path = path.substring(0, n);
            }
            File output = new File(path + ".out" + ext);
            System.out.println("------------------------------------------------------------");
            System.out.println(" Input: " + input.getAbsolutePath());
            System.out.println("Output: " + output.getAbsolutePath());
            reader.open(input.toURI());
            XLIFFWriter writer = new XLIFFWriter();
            writer.setInlineStyle(outputStyle);
            writer.create(output, null);
            while (reader.hasNext()) {
                XLIFFEvent event = reader.next();
                switch (event.getType()) {
                    case START_DOCUMENT: {
                        main.printLine("Start document");
                        break;
                    }
                    case START_SECTION: {
                        SectionData sd = event.getSectionData();
                        main.printLine(String.format("Start section (file id=%s):", sd.getId()));
                        main.printLine(String.format("original=%s", sd.getOriginal()));
                        main.printLine(String.format("source language=%s", sd.getSourceLanguage()));
                        main.printLine(String.format("target language=%s", sd.getTargetLanguage()));
                        break;
                    }
                    case START_GROUP: {
                        GroupData gd = event.getGroupData();
                        main.printLine(String.format("Start group (id=%s):", gd.getId()));
                        main.printLine(String.format("type=%s", gd.getType()));
                        break;
                    }
                    case EXTRACTION_UNIT: {
                        Unit unit = event.getUnit();
                        main.printLine(String.format("Unit (id=%s):", unit.getId()));
                        for (Part part : unit) {
                            main.printPart(part);
                        }
                        break;
                    }
                    case END_GROUP: {
                        main.printLine("End group");
                        break;
                    }
                    case END_SECTION: {
                        main.printLine("End section");
                        break;
                    }
                    case END_DOCUMENT: {
                        main.printLine("End document");
                    }
                }
                writer.writeEvent(event);
            }
            writer.close();
            reader.close();
        }
        System.out.println("============================================================\n");
    }

    void printLine(String text) {
        if (this.verbose) {
            System.out.println(text);
        }
    }

    void printPart(Part part) {
        if (!this.verbose) {
            return;
        }
        if (part instanceof Segment) {
            Segment seg = (Segment)part;
            System.out.println(String.format(" segment (id=%s):", seg.getId()));
            System.out.print("  source=");
            System.out.println("[" + seg.getSource().toXLIFF(this.style) + "]");
            System.out.print("  target=");
            if (seg.hasTarget()) {
                System.out.println("[" + seg.getTarget(false).toXLIFF(this.style) + "]");
            } else {
                System.out.println("<no target defined>");
            }
        } else {
            System.out.println(" ignorable:");
            System.out.print("  source=");
            System.out.println("[" + part.getSource().toXLIFF(this.style) + "]");
            System.out.print("  target=");
            if (part.hasTarget()) {
                System.out.println("[" + part.getTarget(false).toXLIFF(this.style) + "]");
            } else {
                System.out.println("<no target defined>");
            }
        }
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

